/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.core.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventType;
import java.util.Map;

public class EventSenderMap
implements EventSender {
    private final EPRuntimeEventSender runtimeEventSender;
    private final EventAdapterService eventAdapterService;
    private final MapEventType mapEventType;
    private final ThreadingService threadingService;

    public EventSenderMap(EPRuntimeEventSender runtimeEventSender, MapEventType mapEventType, EventAdapterService eventAdapterService, ThreadingService threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.mapEventType = mapEventType;
        this.threadingService = threadingService;
        this.eventAdapterService = eventAdapterService;
    }

    public void sendEvent(Object event) {
        if (!(event instanceof Map)) {
            throw new EPException("Unexpected event object of type " + event.getClass().getName() + ", expected " + Map.class.getName());
        }
        Map map = (Map)event;
        EventBean mapEvent = this.eventAdapterService.adaptorForTypedMap(map, this.mapEventType);
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(new InboundUnitSendWrapped(mapEvent, this.runtimeEventSender));
        } else {
            this.runtimeEventSender.processWrappedEvent(mapEvent);
        }
    }

    public void route(Object event) {
        if (!(event instanceof Map)) {
            throw new EPException("Unexpected event object of type " + event.getClass().getName() + ", expected " + Map.class.getName());
        }
        Map map = (Map)event;
        EventBean mapEvent = this.eventAdapterService.adaptorForTypedMap(map, this.mapEventType);
        this.runtimeEventSender.routeEventBean(mapEvent);
    }
}

