/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.core.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.xml.BaseXMLEventType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventSenderXMLDOM
implements EventSender {
    private final EPRuntimeEventSender runtimeEventSender;
    private final BaseXMLEventType baseXMLEventType;
    private final boolean validateRootElement;
    private final EventAdapterService eventAdapterService;
    private final ThreadingService threadingService;

    public EventSenderXMLDOM(EPRuntimeEventSender runtimeEventSender, BaseXMLEventType baseXMLEventType, EventAdapterService eventAdapterService, ThreadingService threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.baseXMLEventType = baseXMLEventType;
        this.validateRootElement = baseXMLEventType.getConfigurationEventTypeXMLDOM().isEventSenderValidatesRoot();
        this.eventAdapterService = eventAdapterService;
        this.threadingService = threadingService;
    }

    public void sendEvent(Object node) throws EPException {
        this.sendEvent(node, false);
    }

    public void route(Object node) throws EPException {
        this.sendEvent(node, true);
    }

    private void sendEvent(Object node, boolean isRoute) throws EPException {
        Element namedNode;
        if (node instanceof Document) {
            namedNode = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            namedNode = (Element)node;
        } else {
            throw new EPException("Unexpected event object type '" + node.getClass().getName() + "' encountered, please supply a org.w3c.dom.Document or Element node");
        }
        if (this.validateRootElement) {
            String getNodeName = namedNode.getLocalName();
            if (getNodeName == null) {
                getNodeName = namedNode.getNodeName();
            }
            if (!getNodeName.equals(this.baseXMLEventType.getRootElementName())) {
                throw new EPException("Unexpected root element name '" + getNodeName + "' encountered, expected a root element name of '" + this.baseXMLEventType.getRootElementName() + "'");
            }
        }
        EventBean event = this.eventAdapterService.adapterForTypedDOM(namedNode, this.baseXMLEventType);
        if (isRoute) {
            this.runtimeEventSender.routeEventBean(event);
        } else if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(new InboundUnitSendWrapped(event, this.runtimeEventSender));
        } else {
            this.runtimeEventSender.processWrappedEvent(event);
        }
    }
}

