/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.BeanEventTypeFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEventAdapter
implements BeanEventTypeFactory {
    private final ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean;
    private final Lock typesPerJavaBeanLock;
    private final EventAdapterService eventAdapterService;
    private Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs;
    private Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle;
    private ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle = ConfigurationEventTypeLegacy.AccessorStyle.JAVABEAN;

    public BeanEventAdapter(ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean, EventAdapterService eventAdapterService) {
        this.typesPerJavaBean = typesPerJavaBean;
        this.typesPerJavaBeanLock = new ReentrantLock();
        this.classToLegacyConfigs = new HashMap<String, ConfigurationEventTypeLegacy>();
        this.defaultPropertyResolutionStyle = Configuration.PropertyResolutionStyle.getDefault();
        this.eventAdapterService = eventAdapterService;
    }

    public void setDefaultAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle) {
        this.defaultAccessorStyle = defaultAccessorStyle;
    }

    public void setClassToLegacyConfigs(Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs) {
        this.classToLegacyConfigs.putAll(classToLegacyConfigs);
    }

    public void setDefaultPropertyResolutionStyle(Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.defaultPropertyResolutionStyle = defaultPropertyResolutionStyle;
    }

    @Override
    public Configuration.PropertyResolutionStyle getDefaultPropertyResolutionStyle() {
        return this.defaultPropertyResolutionStyle;
    }

    @Override
    public final BeanEventType createBeanTypeDefaultName(Class clazz) {
        return this.createBeanType(clazz.getName(), clazz, false);
    }

    @Override
    public final BeanEventType createBeanType(String name, Class clazz, boolean isConfigured) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null value passed as class");
        }
        BeanEventType eventType = null;
        this.typesPerJavaBeanLock.lock();
        try {
            eventType = this.typesPerJavaBean.get(clazz);
            if (eventType != null) {
                BeanEventType beanEventType = eventType;
                return beanEventType;
            }
            ConfigurationEventTypeLegacy legacyDef = this.classToLegacyConfigs.get(clazz.getName());
            if (legacyDef == null && this.defaultAccessorStyle != ConfigurationEventTypeLegacy.AccessorStyle.JAVABEAN) {
                legacyDef = new ConfigurationEventTypeLegacy();
                legacyDef.setAccessorStyle(this.defaultAccessorStyle);
            }
            EventTypeMetadata metadata = EventTypeMetadata.createBeanType(name, clazz, isConfigured);
            eventType = new BeanEventType(metadata, clazz, this.eventAdapterService, legacyDef);
            this.typesPerJavaBean.put(clazz, eventType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.typesPerJavaBeanLock.unlock();
        }
        return eventType;
    }
}

