/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.DynamicPropertyDescriptor;
import com.espertech.esper.event.bean.DynamicPropertyGetterBase;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DynamicIndexedPropertyGetter
extends DynamicPropertyGetterBase {
    private final String getterMethodName;
    private final Object[] params;
    private final int index;

    public DynamicIndexedPropertyGetter(String fieldName, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService);
        this.getterMethodName = DynamicIndexedPropertyGetter.getGetterMethodName(fieldName);
        this.params = new Object[]{index};
        this.index = index;
    }

    protected Method determineMethod(Class clazz) {
        try {
            return clazz.getMethod(this.getterMethodName, Integer.TYPE);
        }
        catch (NoSuchMethodException ex1) {
            Method method;
            try {
                method = clazz.getMethod(this.getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
            if (!method.getReturnType().isArray()) {
                return null;
            }
            return method;
        }
    }

    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        try {
            if (descriptor.isHasParameters()) {
                return descriptor.getMethod().invoke(underlying, this.params);
            }
            Object array = descriptor.getMethod().invoke(underlying, null);
            if (array == null) {
                return null;
            }
            if (Array.getLength(array) <= this.index) {
                return null;
            }
            return Array.get(array, this.index);
        }
        catch (ClassCastException e2) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e3) {
            throw new PropertyAccessException(e3);
        }
        catch (IllegalArgumentException e4) {
            throw new PropertyAccessException(e4);
        }
    }

    private static String getGetterMethodName(String propertyName) {
        StringWriter writer = new StringWriter();
        writer.write("get");
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }
}

