/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.DynamicPropertyDescriptor;
import com.espertech.esper.event.bean.DynamicPropertyGetterBase;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DynamicSimplePropertyGetter
extends DynamicPropertyGetterBase {
    private final String getterMethodName;
    private final String isMethodName;

    public DynamicSimplePropertyGetter(String fieldName, EventAdapterService eventAdapterService) {
        super(eventAdapterService);
        this.getterMethodName = DynamicSimplePropertyGetter.getGetterMethodName(fieldName);
        this.isMethodName = DynamicSimplePropertyGetter.getIsMethodName(fieldName);
    }

    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        try {
            return descriptor.getMethod().invoke(underlying, null);
        }
        catch (ClassCastException e2) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e3) {
            throw new PropertyAccessException(e3);
        }
        catch (IllegalArgumentException e4) {
            throw new PropertyAccessException(e4);
        }
    }

    protected Method determineMethod(Class clazz) {
        try {
            return clazz.getMethod(this.getterMethodName, new Class[0]);
        }
        catch (NoSuchMethodException ex1) {
            try {
                return clazz.getMethod(this.isMethodName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
    }

    private static String getGetterMethodName(String propertyName) {
        StringWriter writer = new StringWriter();
        writer.write("get");
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }

    private static String getIsMethodName(String propertyName) {
        StringWriter writer = new StringWriter();
        writer.write("is");
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }
}

