/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.BeanEventType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventBeanManufacturerBean
implements EventBeanManufacturer {
    private static Log log = LogFactory.getLog(EventBeanManufacturerBean.class);
    private final FastClass fastClass;
    private final BeanEventType beanEventType;
    private final EventAdapterService service;
    private final FastMethod[] writeMethods;
    private final FastMethod factoryMethod;
    private final boolean hasPrimitiveTypes;
    private final boolean[] primitiveType;

    public EventBeanManufacturerBean(BeanEventType beanEventType, EventAdapterService service, WriteablePropertyDescriptor[] properties, MethodResolutionService methodResolutionService) throws EventBeanManufactureException {
        this.fastClass = beanEventType.getFastClass();
        this.beanEventType = beanEventType;
        this.service = service;
        if (beanEventType.getFactoryMethodName() != null) {
            this.factoryMethod = EventBeanManufacturerBean.resolveFactoryMethod(this.fastClass, beanEventType.getFactoryMethodName(), methodResolutionService);
        } else {
            this.factoryMethod = null;
            try {
                this.fastClass.newInstance();
            }
            catch (InvocationTargetException e2) {
                String message = "Failed to instantiate class '" + this.fastClass.getJavaClass().getName() + "', define a factory method if the class has no default constructor: " + e2.getTargetException().getMessage();
                log.info(message, e2);
                throw new EventBeanManufactureException(message, e2.getTargetException());
            }
            catch (IllegalArgumentException e3) {
                String message = "Failed to instantiate class '" + this.fastClass.getJavaClass().getName() + "', define a factory method if the class has no default constructor";
                log.info(message, e3);
                throw new EventBeanManufactureException(message, e3);
            }
        }
        this.writeMethods = new FastMethod[properties.length];
        boolean primitiveTypeCheck = false;
        this.primitiveType = new boolean[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.writeMethods[i] = this.fastClass.getMethod(properties[i].getWriteMethod());
            this.primitiveType[i] = properties[i].getType().isPrimitive();
            primitiveTypeCheck |= this.primitiveType[i];
        }
        this.hasPrimitiveTypes = primitiveTypeCheck;
    }

    public EventBean make(Object[] propertyValues) {
        Object out;
        if (this.factoryMethod == null) {
            try {
                out = this.fastClass.newInstance();
            }
            catch (InvocationTargetException e2) {
                String message = "Unexpected exception encountered invoking newInstance on class '" + this.fastClass.getJavaClass().getName() + "': " + e2.getTargetException().getMessage();
                log.error(message, e2);
                return null;
            }
        }
        try {
            out = this.factoryMethod.invoke(null, null);
        }
        catch (InvocationTargetException e3) {
            String message = "Unexpected exception encountered invoking factory method '" + this.factoryMethod.getName() + "' on class '" + this.factoryMethod.getJavaMethod().getDeclaringClass().getName() + "': " + e3.getTargetException().getMessage();
            log.error(message, e3);
            return null;
        }
        if (!this.hasPrimitiveTypes) {
            Object[] params = new Object[1];
            for (int i = 0; i < this.writeMethods.length; ++i) {
                params[0] = propertyValues[i];
                try {
                    this.writeMethods[i].invoke(out, params);
                    continue;
                }
                catch (InvocationTargetException e4) {
                    String message = "Unexpected exception encountered invoking setter-method '" + this.writeMethods[i] + "' on class '" + this.fastClass.getJavaClass().getName() + "' : " + e4.getTargetException().getMessage();
                    log.error(message, e4);
                }
            }
        } else {
            Object[] params = new Object[1];
            for (int i = 0; i < this.writeMethods.length; ++i) {
                if (this.primitiveType[i] && propertyValues[i] == null) continue;
                params[0] = propertyValues[i];
                try {
                    this.writeMethods[i].invoke(out, params);
                    continue;
                }
                catch (InvocationTargetException e5) {
                    String message = "Unexpected exception encountered invoking setter-method '" + this.writeMethods[i] + "' on class '" + this.fastClass.getJavaClass().getName() + "' : " + e5.getTargetException().getMessage();
                    log.error(message, e5);
                }
            }
        }
        return this.service.adapterForTypedBean(out, this.beanEventType);
    }

    private static FastMethod resolveFactoryMethod(FastClass fastClass, String factoryMethodName, MethodResolutionService methodResolutionService) throws EventBeanManufactureException {
        int lastDotIndex = factoryMethodName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            try {
                Method method = methodResolutionService.resolveMethod(fastClass.getJavaClass(), factoryMethodName, new Class[0]);
                return fastClass.getMethod(method);
            }
            catch (EngineImportException e2) {
                String message = "Failed to resolve configured factory method '" + factoryMethodName + "' expected to exist for class '" + fastClass.getName() + "'";
                log.info(message, e2);
                throw new EventBeanManufactureException(message, e2);
            }
        }
        String className = factoryMethodName.substring(0, lastDotIndex);
        String methodName = factoryMethodName.substring(lastDotIndex + 1);
        try {
            Method method = methodResolutionService.resolveMethod(className, methodName, new Class[0]);
            FastClass fastClassFactory = FastClass.create(method.getDeclaringClass());
            return fastClassFactory.getMethod(method);
        }
        catch (EngineImportException e3) {
            String message = "Failed to resolve configured factory method '" + methodName + "' expected to exist for class '" + className + "'";
            log.info(message, e3);
            throw new EventBeanManufactureException(message, e3);
        }
    }
}

