/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;

public class KeyedFastPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final FastMethod fastMethod;
    private final Object key;

    public KeyedFastPropertyGetter(FastMethod fastMethod, Object key, EventAdapterService eventAdapterService) {
        super(eventAdapterService, fastMethod.getReturnType(), null);
        this.key = key;
        this.fastMethod = fastMethod;
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            return this.fastMethod.invoke(object, new Object[]{this.key});
        }
        catch (ClassCastException e2) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e3) {
            throw new PropertyAccessException(e3);
        }
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "KeyedFastPropertyGetter  fastMethod=" + this.fastMethod.toString() + " key=" + this.key;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

