/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Field;
import java.util.Map;

public class KeyedMapFieldPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final Field field;
    private final Object key;

    public KeyedMapFieldPropertyGetter(Field field, Object key, EventAdapterService eventAdapterService) {
        super(eventAdapterService, JavaClassHelper.getGenericFieldTypeMap(field, false), null);
        this.key = key;
        this.field = field;
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object result = this.field.get(object);
            if (!(result instanceof Map)) {
                return null;
            }
            Map resultMap = (Map)result;
            return resultMap.get(this.key);
        }
        catch (ClassCastException e2) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (IllegalAccessException e3) {
            throw new PropertyAccessException(e3);
        }
        catch (IllegalArgumentException e4) {
            throw new PropertyAccessException(e4);
        }
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "KeyedMapFieldPropertyGetter  field=" + this.field.toString() + " key=" + this.key;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

