/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class KeyedMapMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final Method method;
    private final Object key;

    public KeyedMapMethodPropertyGetter(Method method, Object key, EventAdapterService eventAdapterService) {
        super(eventAdapterService, JavaClassHelper.getGenericReturnTypeMap(method, false), null);
        this.key = key;
        this.method = method;
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object result = this.method.invoke(object, (Object[])null);
            if (!(result instanceof Map)) {
                return null;
            }
            Map resultMap = (Map)result;
            return resultMap.get(this.key);
        }
        catch (ClassCastException e2) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e3) {
            throw new PropertyAccessException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new PropertyAccessException(e4);
        }
        catch (IllegalArgumentException e5) {
            throw new PropertyAccessException(e5);
        }
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "KeyedMapMethodPropertyGetter  method=" + this.method.toString() + " key=" + this.key;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

