/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Field;
import java.util.List;

public class ListFieldPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final Field field;
    private final int index;

    public ListFieldPropertyGetter(Field field, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, JavaClassHelper.getGenericFieldType(field, false), null);
        this.index = index;
        this.field = field;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object value = this.field.get(object);
            if (!(value instanceof List)) {
                return null;
            }
            List valueList = (List)value;
            if (valueList.size() <= this.index) {
                return null;
            }
            return valueList.get(this.index);
        }
        catch (ClassCastException e2) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (IllegalAccessException e3) {
            throw new PropertyAccessException(e3);
        }
        catch (IllegalArgumentException e4) {
            throw new PropertyAccessException(e4);
        }
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ListFieldPropertyGetter  field=" + this.field.toString() + " index=" + this.index;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

