/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ListMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final Method method;
    private final int index;

    public ListMethodPropertyGetter(Method method, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, JavaClassHelper.getGenericReturnType(method, false), null);
        this.index = index;
        this.method = method;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object value = this.method.invoke(object, (Object[])null);
            if (!(value instanceof List)) {
                return null;
            }
            List valueList = (List)value;
            if (valueList.size() <= this.index) {
                return null;
            }
            return valueList.get(this.index);
        }
        catch (ClassCastException e2) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e3) {
            throw new PropertyAccessException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new PropertyAccessException(e4);
        }
        catch (IllegalArgumentException e5) {
            throw new PropertyAccessException(e5);
        }
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ListMethodPropertyGetter  method=" + this.method.toString() + " index=" + this.index;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

