/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.lang.reflect.Array;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapArrayPOJOEntryIndexedPropertyGetter
extends BaseNativePropertyGetter
implements MapEventPropertyGetter {
    private final String propertyMap;
    private final int index;

    public MapArrayPOJOEntryIndexedPropertyGetter(String propertyMap, int index, EventAdapterService eventAdapterService, Class returnType) {
        super(eventAdapterService, returnType, null);
        this.propertyMap = propertyMap;
        this.index = index;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.propertyMap);
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        if (Array.getLength(value) <= this.index) {
            return null;
        }
        return Array.get(value, this.index);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return map.containsKey(this.propertyMap);
    }

    @Override
    public Object get(EventBean obj) {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return map.containsKey(this.propertyMap);
    }
}

