/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMappedPropertyGetter
implements MapEventPropertyGetter {
    private final String key;
    private final String fieldName;

    public MapMappedPropertyGetter(String fieldName, String key) {
        this.key = key;
        this.fieldName = fieldName;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.fieldName);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            return null;
        }
        Map innerMap = (Map)value;
        return innerMap.get(this.key);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        Object value = map.get(this.fieldName);
        if (value == null) {
            return false;
        }
        if (!(value instanceof Map)) {
            return false;
        }
        Map innerMap = (Map)value;
        return innerMap.containsKey(this.key);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            return null;
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            return false;
        }
        Map map = (Map)underlying;
        return this.isMapExistsProperty(map);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }
}

