/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapEventType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMaptypedEntryPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyMap;
    private final EventPropertyGetter eventBeanEntryGetter;
    private final MapEventType fragmentType;
    private final EventAdapterService eventAdapterService;

    public MapMaptypedEntryPropertyGetter(String propertyMap, EventPropertyGetter eventBeanEntryGetter, MapEventType fragmentType, EventAdapterService eventAdapterService) {
        this.propertyMap = propertyMap;
        this.eventBeanEntryGetter = eventBeanEntryGetter;
        this.fragmentType = fragmentType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.propertyMap);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            return null;
        }
        EventBean eventBean = this.eventAdapterService.adaptorForTypedMap((Map)value, this.fragmentType);
        return this.eventBeanEntryGetter.get(eventBean);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        Object value = map.get(this.propertyMap);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            return null;
        }
        EventBean eventBean = this.eventAdapterService.adaptorForTypedMap((Map)value, this.fragmentType);
        return this.eventBeanEntryGetter.getFragment(eventBean);
    }
}

