/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.property;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ExceptionConvertor;
import com.espertech.esper.event.property.DynamicIndexedProperty;
import com.espertech.esper.event.property.DynamicMappedProperty;
import com.espertech.esper.event.property.DynamicSimpleProperty;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.SimpleProperty;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.StringValue;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyParser {
    private static final Log log = LogFactory.getLog(PropertyParser.class);
    private static Set<String> keywordCache;

    public static Property parse(String propertyName, boolean isRootedDynamic) {
        Tree tree = PropertyParser.parse(propertyName);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            ASTUtil.dumpAST(tree);
        }
        if (tree.getChildCount() == 1) {
            return PropertyParser.makeProperty(tree.getChild(0), isRootedDynamic);
        }
        LinkedList<Property> properties = new LinkedList<Property>();
        boolean isRootedInDynamic = isRootedDynamic;
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree child = tree.getChild(i);
            Property property = PropertyParser.makeProperty(child, isRootedInDynamic);
            if (property instanceof DynamicSimpleProperty) {
                isRootedInDynamic = true;
            }
            properties.add(property);
        }
        return new NestedProperty(properties);
    }

    public static Tree parse(String propertyName) {
        EsperEPL2GrammarParser.startEventPropertyRule_return r;
        NoCaseSensitiveStream input;
        try {
            input = new NoCaseSensitiveStream(new StringReader(propertyName));
        }
        catch (IOException ex) {
            throw new PropertyAccessException("IOException parsing property name '" + propertyName + '\'', ex);
        }
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer(input);
        CommonTokenStream tokens2 = new CommonTokenStream(lex);
        EsperEPL2GrammarParser g = new EsperEPL2GrammarParser(tokens2);
        try {
            r = g.startEventPropertyRule();
        }
        catch (RuntimeException e2) {
            if (log.isDebugEnabled()) {
                log.debug("Error parsing property expression [" + propertyName + "]", e2);
            }
            if (e2.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convertProperty((RecognitionException)e2.getCause(), propertyName, true, g);
            }
            throw e2;
        }
        catch (RecognitionException e3) {
            NoCaseSensitiveStream inputEscaped;
            String escapedPropertyName = PropertyParser.escapeKeywords(tokens2);
            try {
                inputEscaped = new NoCaseSensitiveStream(new StringReader(escapedPropertyName));
            }
            catch (IOException ex) {
                throw new PropertyAccessException("IOException parsing property name '" + propertyName + '\'', ex);
            }
            EsperEPL2GrammarLexer lexEscaped = new EsperEPL2GrammarLexer(inputEscaped);
            CommonTokenStream tokensEscaped = new CommonTokenStream(lexEscaped);
            EsperEPL2GrammarParser gEscaped = new EsperEPL2GrammarParser(tokensEscaped);
            try {
                EsperEPL2GrammarParser.startEventPropertyRule_return rEscaped = gEscaped.startEventPropertyRule();
                return (Tree)rEscaped.getTree();
            }
            catch (Exception eEscaped) {
                throw ExceptionConvertor.convertProperty(e3, propertyName, true, g);
            }
        }
        return (Tree)r.getTree();
    }

    private static synchronized String escapeKeywords(CommonTokenStream tokens2) {
        if (keywordCache == null) {
            keywordCache = new HashSet<String>();
            Set<String> keywords = new EsperEPL2GrammarParser(tokens2).getKeywords();
            for (String keyword : keywords) {
                if (keyword.charAt(0) != '\'' || keyword.charAt(keyword.length() - 1) != '\'') continue;
                keywordCache.add(keyword.substring(1, keyword.length() - 1));
            }
        }
        StringWriter writer = new StringWriter();
        for (Object token : tokens2.getTokens()) {
            Token t = (Token)token;
            boolean isKeyword = keywordCache.contains(t.getText().toLowerCase());
            if (isKeyword) {
                writer.append('`');
                writer.append(t.getText());
                writer.append('`');
                continue;
            }
            writer.append(t.getText());
        }
        return writer.toString();
    }

    public static boolean isPropertyDynamic(Tree ast) {
        for (int i = 0; i < ast.getChildCount(); ++i) {
            int type = ast.getChild(i).getType();
            if (type != 165 && type != 166 && type != 167) continue;
            return true;
        }
        return false;
    }

    private static Property makeProperty(Tree child, boolean isRootedInDynamic) {
        switch (child.getType()) {
            case 162: {
                if (!isRootedInDynamic) {
                    return new SimpleProperty(child.getChild(0).getText());
                }
                return new DynamicSimpleProperty(child.getChild(0).getText());
            }
            case 163: {
                String key = StringValue.parseString(child.getChild(1).getText());
                if (!isRootedInDynamic) {
                    return new MappedProperty(child.getChild(0).getText(), key);
                }
                return new DynamicMappedProperty(child.getChild(0).getText(), key);
            }
            case 164: {
                int index = IntValue.parseString(child.getChild(1).getText());
                if (!isRootedInDynamic) {
                    return new IndexedProperty(child.getChild(0).getText(), index);
                }
                return new DynamicIndexedProperty(child.getChild(0).getText(), index);
            }
            case 165: {
                return new DynamicSimpleProperty(child.getChild(0).getText());
            }
            case 166: {
                int index = IntValue.parseString(child.getChild(1).getText());
                return new DynamicIndexedProperty(child.getChild(0).getText(), index);
            }
            case 167: {
                String key = StringValue.parseString(child.getChild(1).getText());
                return new DynamicMappedProperty(child.getChild(0).getText(), key);
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }
}

