/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.vaevent.RevisionEventType;
import com.espertech.esper.event.vaevent.RevisionSpec;
import com.espertech.esper.event.vaevent.RevisionTypeDesc;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class VAERevisionProcessorBase
implements ValueAddEventProcessor {
    protected final RevisionSpec revisionSpec;
    protected final String revisionEventTypeName;
    protected RevisionEventType revisionEventType;
    protected EventAdapterService eventAdapterService;
    protected Map<EventType, RevisionTypeDesc> typeDescriptors;

    protected VAERevisionProcessorBase(RevisionSpec revisionSpec, String revisioneventTypeName, EventAdapterService eventAdapterService) {
        this.revisionSpec = revisionSpec;
        this.revisionEventTypeName = revisioneventTypeName;
        this.eventAdapterService = eventAdapterService;
        this.typeDescriptors = new HashMap<EventType, RevisionTypeDesc>();
    }

    public RevisionEventType getValueAddEventType() {
        return this.revisionEventType;
    }

    public void validateEventType(EventType eventType) throws ExprValidationException {
        if (eventType == this.revisionSpec.getBaseEventType()) {
            return;
        }
        if (this.typeDescriptors.containsKey(eventType)) {
            return;
        }
        if (eventType == null) {
            throw new ExprValidationException(this.getMessage());
        }
        Iterator<EventType> deepSupers = eventType.getDeepSuperTypes();
        if (deepSupers == null) {
            throw new ExprValidationException(this.getMessage());
        }
        while (deepSupers.hasNext()) {
            EventType type = deepSupers.next();
            if (type == this.revisionSpec.getBaseEventType()) {
                return;
            }
            if (!this.typeDescriptors.containsKey(type)) continue;
            return;
        }
        throw new ExprValidationException(this.getMessage());
    }

    private String getMessage() {
        return "Selected event type is not a valid base or delta event type of revision event type '" + this.revisionEventTypeName + "'";
    }
}

