/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.event.xml.FragmentFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMComplexElementGetter
implements EventPropertyGetter,
DOMPropertyGetter {
    private final String propertyName;
    private final FragmentFactory fragmentFactory;
    private final boolean isArray;

    public DOMComplexElementGetter(String propertyName, FragmentFactory fragmentFactory, boolean isArray) {
        this.propertyName = propertyName;
        this.fragmentFactory = fragmentFactory;
        this.isArray = isArray;
    }

    public Object getValueAsFragment(Node node) {
        if (!this.isArray) {
            Node result = this.getValueAsNode(node);
            if (result == null) {
                return result;
            }
            return this.fragmentFactory.getEvent(result);
        }
        Node[] result = this.getValueAsNodeArray(node);
        if (result == null || result.length == 0) {
            return new EventBean[0];
        }
        EventBean[] events = new EventBean[result.length];
        int count = 0;
        for (int i = 0; i < result.length; ++i) {
            events[count++] = this.fragmentFactory.getEvent(result[i]);
        }
        return events;
    }

    public Node getValueAsNode(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode == null || childNode.getNodeType() != 1 || !(childNode.getLocalName() != null ? this.propertyName.equals(childNode.getLocalName()) : this.propertyName.equals(childNode.getNodeName()))) continue;
            return childNode;
        }
        return null;
    }

    public Node[] getValueAsNodeArray(Node node) {
        NodeList list = node.getChildNodes();
        int count = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode == null || childNode.getNodeType() != 1) continue;
            ++count;
        }
        if (count == 0) {
            return new Node[0];
        }
        Node[] nodes = new Node[count];
        int realized = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1) continue;
            if (childNode.getLocalName() != null) {
                if (!this.propertyName.equals(childNode.getLocalName())) continue;
                nodes[realized++] = childNode;
                continue;
            }
            if (!childNode.getNodeName().equals(this.propertyName)) continue;
            nodes[realized++] = childNode;
        }
        if (realized == count) {
            return nodes;
        }
        if (realized == 0) {
            return new Node[0];
        }
        Node[] shrunk = new Node[realized];
        System.arraycopy(nodes, 0, shrunk, 0, realized);
        return shrunk;
    }

    public Object get(EventBean obj) throws PropertyAccessException {
        if (!(obj.getUnderlying() instanceof Node)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type Node");
        }
        if (!this.isArray) {
            Node node = (Node)obj.getUnderlying();
            return this.getValueAsNode(node);
        }
        Node node = (Node)obj.getUnderlying();
        return this.getValueAsNodeArray(node);
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    public Object getFragment(EventBean obj) throws PropertyAccessException {
        if (!(obj.getUnderlying() instanceof Node)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type Node");
        }
        Node node = (Node)obj.getUnderlying();
        return this.getValueAsFragment(node);
    }
}

