/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import java.lang.reflect.Array;
import org.w3c.dom.Node;

public class DOMConvertingArrayGetter
implements EventPropertyGetter {
    private final DOMPropertyGetter getter;
    private final Class componentType;
    private final SimpleTypeParser parser;

    public DOMConvertingArrayGetter(DOMPropertyGetter domPropertyGetter, Class returnType) {
        this.getter = domPropertyGetter;
        this.componentType = returnType;
        this.parser = SimpleTypeParserFactory.getParser(returnType);
    }

    public Object get(EventBean obj) throws PropertyAccessException {
        if (!(obj.getUnderlying() instanceof Node)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type Node");
        }
        Node node = (Node)obj.getUnderlying();
        Node[] result = this.getter.getValueAsNodeArray(node);
        if (result == null) {
            return null;
        }
        Object array = Array.newInstance(this.componentType, result.length);
        for (int i = 0; i < result.length; ++i) {
            String text = result[i].getTextContent();
            if (text == null || text.length() == 0) continue;
            Object parseResult = this.parser.parse(text);
            Array.set(array, i, parseResult);
        }
        return array;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

