/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.event.xml.SchemaModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtil {
    private static Map<String, Class> typeMap = new HashMap<String, Class>();

    public static Class toReturnType(SchemaItem item) {
        if (item instanceof SchemaItemAttribute) {
            SchemaItemAttribute att = (SchemaItemAttribute)item;
            return SchemaUtil.toReturnType(att.getXsSimpleType(), att.getTypeName(), null);
        }
        if (item instanceof SchemaElementSimple) {
            SchemaElementSimple simple = (SchemaElementSimple)item;
            Class<?> returnType = SchemaUtil.toReturnType(simple.getXsSimpleType(), simple.getTypeName(), simple.getFractionDigits());
            if (simple.isArray()) {
                returnType = Array.newInstance(returnType, 0).getClass();
            }
            return returnType;
        }
        if (item instanceof SchemaElementComplex) {
            SchemaElementComplex complex = (SchemaElementComplex)item;
            if (complex.getOptionalSimpleType() != null) {
                return SchemaUtil.toReturnType(complex.getOptionalSimpleType(), complex.getOptionalSimpleTypeName(), null);
            }
            if (complex.isArray()) {
                return NodeList.class;
            }
            return Node.class;
        }
        throw new PropertyAccessException("Invalid schema return type:" + item);
    }

    public static Class toReturnType(short xsType, String typeName, Integer optionalFractionDigits) {
        Class result;
        if (typeName != null && (result = typeMap.get(typeName)) != null) {
            return result;
        }
        switch (xsType) {
            case 2: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 3: {
                if (optionalFractionDigits != null && optionalFractionDigits > 0) {
                    return Double.class;
                }
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return Double.class;
            }
        }
        return String.class;
    }

    public static Class toReturnType(QName resultType, Class optionalCastToType) {
        if (optionalCastToType != null) {
            return optionalCastToType;
        }
        if (resultType.equals(XPathConstants.NODESET)) {
            return NodeList.class;
        }
        if (resultType.equals(XPathConstants.NODE)) {
            return Node.class;
        }
        if (resultType.equals(XPathConstants.BOOLEAN)) {
            return Boolean.class;
        }
        if (resultType.equals(XPathConstants.NUMBER)) {
            return Double.class;
        }
        if (resultType.equals(XPathConstants.STRING)) {
            return String.class;
        }
        return String.class;
    }

    public static QName simpleTypeToQName(short type) {
        switch (type) {
            case 2: {
                return XPathConstants.BOOLEAN;
            }
            case 5: {
                return XPathConstants.NUMBER;
            }
            case 1: {
                return XPathConstants.STRING;
            }
            case 3: {
                return XPathConstants.NUMBER;
            }
            case 4: {
                return XPathConstants.NUMBER;
            }
            case 7: {
                return XPathConstants.STRING;
            }
            case 9: {
                return XPathConstants.STRING;
            }
            case 8: {
                return XPathConstants.STRING;
            }
        }
        throw new EPException("Unexpected schema simple type encountered '" + type + "'");
    }

    public static SchemaElementComplex findRootElement(SchemaModel schema, String namespace2, String elementName) {
        if (namespace2 != null && namespace2.length() != 0) {
            for (SchemaElementComplex complexElement : schema.getComponents()) {
                if (!complexElement.getNamespace().equals(namespace2) || !complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        } else {
            for (SchemaElementComplex complexElement : schema.getComponents()) {
                if (!complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        }
        if (elementName.startsWith("//")) {
            elementName = elementName.substring(2);
            for (SchemaElementComplex complexElement : schema.getComponents()) {
                SchemaElementComplex match = SchemaUtil.recursiveDeepMatch(complexElement, namespace2, elementName);
                if (match == null) continue;
                return match;
            }
        }
        String text = "Could not find root element declaration in schema for element name '" + elementName + '\'';
        if (namespace2 != null) {
            text = text + " in namespace '" + namespace2 + '\'';
        }
        throw new EPException(text);
    }

    private static SchemaElementComplex recursiveDeepMatch(SchemaElementComplex parent, String namespace2, String elementName) {
        if (namespace2 != null && namespace2.length() != 0) {
            for (SchemaElementComplex complexElement : parent.getChildren()) {
                if (!complexElement.getNamespace().equals(namespace2) || !complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        } else {
            for (SchemaElementComplex complexElement : parent.getChildren()) {
                if (!complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        }
        for (SchemaElementComplex complexElement : parent.getChildren()) {
            SchemaElementComplex found = SchemaUtil.recursiveDeepMatch(complexElement, namespace2, elementName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static SchemaItem findPropertyMapping(SchemaElementComplex def, String property) {
        for (SchemaItemAttribute attribute : def.getAttributes()) {
            if (!attribute.getName().equals(property)) continue;
            return attribute;
        }
        for (SchemaElementSimple simple : def.getSimpleElements()) {
            if (!simple.getName().equals(property)) continue;
            return simple;
        }
        for (SchemaElementComplex complex : def.getChildren()) {
            if (!complex.getName().equals(property)) continue;
            return complex;
        }
        return null;
    }

    public static String serialize(Node doc) {
        StringWriter writer = new StringWriter();
        try {
            SchemaUtil.serializeNode(doc, "", writer);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        writer.flush();
        return writer.toString();
    }

    private static void serializeNode(Node node, String indentLevel, StringWriter writer) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                writer.write("<?xml version=\"");
                writer.write(doc.getXmlVersion());
                writer.write("\" encoding=\"UTF-8\" standalone=\"");
                if (doc.getXmlStandalone()) {
                    writer.write("yes");
                } else {
                    writer.write("no");
                }
                writer.write("\"?>\n");
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    SchemaUtil.serializeNode(nodes.item(i), "", writer);
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write(indentLevel + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    writer.write(" " + current.getNodeName() + "=\"");
                    SchemaUtil.print(current.getNodeValue(), writer);
                    writer.write("\"");
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        writer.write("\n");
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        SchemaUtil.serializeNode(children.item(i), indentLevel, writer);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write(indentLevel);
                    }
                }
                writer.write("</" + name + ">\n");
                break;
            }
            case 3: {
                SchemaUtil.print(node.getNodeValue(), writer);
                break;
            }
            case 4: {
                writer.write("CDATA");
                SchemaUtil.print(node.getNodeValue(), writer);
                writer.write("");
                break;
            }
            case 8: {
                writer.write(indentLevel + "<!-- " + node.getNodeValue() + " -->\n");
                break;
            }
            case 7: {
                writer.write("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>\n");
                break;
            }
            case 5: {
                writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                String publicId = docType.getPublicId();
                String systemId = docType.getSystemId();
                String internalSubset = docType.getInternalSubset();
                writer.write("<!DOCTYPE " + docType.getName());
                if (publicId != null) {
                    writer.write(" PUBLIC \"" + publicId + "\" ");
                } else {
                    writer.write(" SYSTEM ");
                }
                writer.write("\"" + systemId + "\"");
                if (internalSubset != null) {
                    writer.write(" [" + internalSubset + "]");
                }
                writer.write(">\n");
            }
        }
    }

    private static void print(String s, Writer writer) throws IOException {
        if (s == null) {
            return;
        }
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '\r': {
                    writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    static {
        Object[][] types = new Object[][]{{"nonPositiveInteger", Integer.class}, {"nonNegativeInteger", Integer.class}, {"negativeInteger", Integer.class}, {"positiveInteger", Integer.class}, {"long", Long.class}, {"unsignedLong", Long.class}, {"int", Integer.class}, {"unsignedInt", Integer.class}, {"decimal", Double.class}, {"integer", Integer.class}, {"float", Float.class}, {"double", Double.class}, {"string", String.class}, {"short", Short.class}, {"unsignedShort", Short.class}, {"byte", Byte.class}, {"unsignedByte", Byte.class}, {"boolean", Boolean.class}, {"dateTime", String.class}, {"date", String.class}, {"time", String.class}};
        for (int i = 0; i < types.length; ++i) {
            typeMap.put(types[i][0].toString(), (Class)types[i][1]);
        }
    }
}

