/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.ExplicitPropertyDescriptor;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.DOMConvertingArrayGetter;
import com.espertech.esper.event.xml.DOMConvertingGetter;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.SchemaUtil;
import com.espertech.esper.event.xml.SchemaXMLPropertyParser;
import com.espertech.esper.event.xml.XPathNamespaceContext;
import com.espertech.esper.event.xml.XPathPropertyArrayItemGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaXMLEventType
extends BaseXMLEventType {
    private static final Log log = LogFactory.getLog(SchemaXMLEventType.class);
    private final SchemaModel schemaModel;
    private final SchemaElementComplex schemaModelRoot;
    private final String rootElementNamespace;
    private final Map<String, EventPropertyGetter> propertyGetterCache = new HashMap<String, EventPropertyGetter>();
    private final boolean isPropertyExpressionXPath;

    public SchemaXMLEventType(EventTypeMetadata eventTypeMetadata, ConfigurationEventTypeXMLDOM config, SchemaModel schemaModel, EventAdapterService eventAdapterService) {
        super(eventTypeMetadata, config, eventAdapterService);
        ExplicitPropertyDescriptor explicit;
        EventPropertyDescriptor desc;
        Class returnType;
        String propertyName;
        this.schemaModel = schemaModel;
        this.rootElementNamespace = config.getRootElementNamespace();
        this.schemaModelRoot = SchemaUtil.findRootElement(schemaModel, this.rootElementNamespace, this.getRootElementName());
        this.isPropertyExpressionXPath = config.isXPathPropertyExpr();
        XPathNamespaceContext ctx = new XPathNamespaceContext();
        if (config.getDefaultNamespace() != null) {
            ctx.setDefaultNamespace(config.getDefaultNamespace());
        }
        for (Map.Entry<String, String> entry : config.getNamespacePrefixes().entrySet()) {
            ctx.addPrefix(entry.getKey(), entry.getValue());
        }
        super.setNamespaceContext(ctx);
        ArrayList<ExplicitPropertyDescriptor> additionalSchemaProps = new ArrayList<ExplicitPropertyDescriptor>();
        for (SchemaElementComplex complex : this.schemaModelRoot.getChildren()) {
            propertyName = complex.getName();
            returnType = Node.class;
            if (complex.getOptionalSimpleType() != null) {
                returnType = SchemaUtil.toReturnType(complex);
            }
            if (complex.isArray()) {
                returnType = Node[].class;
            }
            boolean isFragment = false;
            if (this.getConfigurationEventTypeXMLDOM().isAutoFragment() && !this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr()) {
                isFragment = this.canFragment(complex);
            }
            EventPropertyGetter getter = this.doResolvePropertyGetter(propertyName, true);
            EventPropertyDescriptor desc2 = new EventPropertyDescriptor(propertyName, returnType, null, false, false, complex.isArray(), false, isFragment);
            ExplicitPropertyDescriptor explicit2 = new ExplicitPropertyDescriptor(desc2, getter, false, null);
            additionalSchemaProps.add(explicit2);
        }
        for (SchemaElementSimple simple : this.schemaModelRoot.getSimpleElements()) {
            propertyName = simple.getName();
            returnType = SchemaUtil.toReturnType(simple);
            EventPropertyGetter getter = this.doResolvePropertyGetter(propertyName, true);
            desc = new EventPropertyDescriptor(propertyName, returnType, null, false, false, simple.isArray(), false, false);
            explicit = new ExplicitPropertyDescriptor(desc, getter, false, null);
            additionalSchemaProps.add(explicit);
        }
        for (SchemaItemAttribute attribute : this.schemaModelRoot.getAttributes()) {
            propertyName = attribute.getName();
            returnType = SchemaUtil.toReturnType(attribute);
            EventPropertyGetter getter = this.doResolvePropertyGetter(propertyName, true);
            desc = new EventPropertyDescriptor(propertyName, returnType, null, false, false, false, false, false);
            explicit = new ExplicitPropertyDescriptor(desc, getter, false, null);
            additionalSchemaProps.add(explicit);
        }
        super.initialize(config.getXPathProperties().values(), additionalSchemaProps);
    }

    protected FragmentEventType doResolveFragmentType(String property) {
        EventType newType;
        if (!this.getConfigurationEventTypeXMLDOM().isAutoFragment() || this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr()) {
            return null;
        }
        Property prop = PropertyParser.parse(property, false);
        SchemaItem item = prop.getPropertyTypeSchema(this.schemaModelRoot, this.getEventAdapterService());
        if (item == null || !this.canFragment(item)) {
            return null;
        }
        SchemaElementComplex complex = (SchemaElementComplex)item;
        String[] atomicProps = prop.toPropertyArray();
        String delimiterDot = ".";
        StringBuilder eventTypeNameBuilder = new StringBuilder(this.getName());
        for (String atomic : atomicProps) {
            eventTypeNameBuilder.append(delimiterDot);
            eventTypeNameBuilder.append(atomic);
        }
        String eventTypeName = eventTypeNameBuilder.toString();
        EventType existingType = this.getEventAdapterService().getExistsTypeByName(eventTypeName);
        if (existingType != null) {
            return new FragmentEventType(existingType, complex.isArray(), false);
        }
        ConfigurationEventTypeXMLDOM xmlDom = new ConfigurationEventTypeXMLDOM();
        xmlDom.setRootElementName("//" + complex.getName());
        xmlDom.setRootElementNamespace(complex.getNamespace());
        xmlDom.setAutoFragment(this.getConfigurationEventTypeXMLDOM().isAutoFragment());
        xmlDom.setEventSenderValidatesRoot(this.getConfigurationEventTypeXMLDOM().isEventSenderValidatesRoot());
        xmlDom.setXPathPropertyExpr(this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr());
        xmlDom.setXPathResolvePropertiesAbsolute(this.getConfigurationEventTypeXMLDOM().isXPathResolvePropertiesAbsolute());
        xmlDom.setSchemaResource(this.getConfigurationEventTypeXMLDOM().getSchemaResource());
        xmlDom.setXPathFunctionResolver(this.getConfigurationEventTypeXMLDOM().getXPathFunctionResolver());
        xmlDom.setXPathVariableResolver(this.getConfigurationEventTypeXMLDOM().getXPathVariableResolver());
        xmlDom.setDefaultNamespace(this.getConfigurationEventTypeXMLDOM().getDefaultNamespace());
        xmlDom.addNamespacePrefixes(this.getConfigurationEventTypeXMLDOM().getNamespacePrefixes());
        try {
            newType = this.getEventAdapterService().addXMLDOMType(eventTypeName, xmlDom, this.schemaModel);
        }
        catch (Exception ex) {
            log.error("Failed to add dynamic event type for fragment of XML schema for property '" + property + "' :" + ex.getMessage(), ex);
            return null;
        }
        return new FragmentEventType(newType, complex.isArray(), false);
    }

    protected Class doResolvePropertyType(String propertyExpression) {
        return this.doResolvePropertyType(propertyExpression, false);
    }

    private Class doResolvePropertyType(String propertyExpression, boolean allowSimpleProperties) {
        Property property;
        int index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyExpression);
        if (!allowSimpleProperties && index == -1 && !(property = PropertyParser.parse(propertyExpression, false)).isDynamic()) {
            if (!(property instanceof IndexedProperty)) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            EventPropertyDescriptor descriptor = (EventPropertyDescriptor)this.propertyDescriptorMap.get(indexedProp.getPropertyNameAtomic());
            if (descriptor == null) {
                return null;
            }
            return descriptor.getPropertyType();
        }
        Property prop = PropertyParser.parse(propertyExpression, false);
        if (prop.isDynamic()) {
            return Node.class;
        }
        SchemaItem item = prop.getPropertyTypeSchema(this.schemaModelRoot, this.getEventAdapterService());
        if (item == null) {
            return null;
        }
        return SchemaUtil.toReturnType(item);
    }

    protected EventPropertyGetter doResolvePropertyGetter(String property) {
        return this.doResolvePropertyGetter(property, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EventPropertyGetter doResolvePropertyGetter(String propertyExpression, boolean allowSimpleProperties) {
        Property property;
        int index;
        EventPropertyGetter getter = this.propertyGetterCache.get(propertyExpression);
        if (getter != null) {
            return getter;
        }
        if (!allowSimpleProperties && (index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyExpression)) == -1 && !(property = PropertyParser.parse(propertyExpression, false)).isDynamic()) {
            if (!(property instanceof IndexedProperty)) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            getter = (EventPropertyGetter)this.propertyGetters.get(indexedProp.getPropertyNameAtomic());
            if (null == getter) {
                return null;
            }
            EventPropertyDescriptor descriptor = (EventPropertyDescriptor)this.propertyDescriptorMap.get(indexedProp.getPropertyNameAtomic());
            if (descriptor == null) {
                return null;
            }
            if (!descriptor.isIndexed()) {
                return null;
            }
            if (descriptor.getPropertyType() == NodeList.class) {
                FragmentFactoryDOMGetter fragmentFactory = new FragmentFactoryDOMGetter(this.getEventAdapterService(), this, indexedProp.getPropertyNameAtomic());
                return new XPathPropertyArrayItemGetter(getter, indexedProp.getIndex(), fragmentFactory);
            }
        }
        if (!this.isPropertyExpressionXPath) {
            Property prop = PropertyParser.parse(propertyExpression, false);
            boolean isDynamic = prop.isDynamic();
            if (isDynamic) return prop.getGetterDOM();
            SchemaItem item = prop.getPropertyTypeSchema(this.schemaModelRoot, this.getEventAdapterService());
            if (item == null) {
                return null;
            }
            getter = prop.getGetterDOM(this.schemaModelRoot, this.getEventAdapterService(), this, propertyExpression);
            if (getter == null) {
                return null;
            }
            Class returnType = SchemaUtil.toReturnType(item);
            if (returnType != Node.class && returnType != NodeList.class) {
                getter = !returnType.isArray() ? new DOMConvertingGetter(propertyExpression, (DOMPropertyGetter)getter, returnType) : new DOMConvertingArrayGetter((DOMPropertyGetter)getter, returnType.getComponentType());
            }
        } else {
            boolean allowFragments = !this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr();
            getter = SchemaXMLPropertyParser.getXPathResolution(propertyExpression, this.getXPathFactory(), this.getRootElementName(), this.rootElementNamespace, this.schemaModel, this.getEventAdapterService(), this, allowFragments, this.getConfigurationEventTypeXMLDOM().getDefaultNamespace());
        }
        this.propertyGetterCache.put(propertyExpression, getter);
        return getter;
    }

    private boolean canFragment(SchemaItem item) {
        if (!(item instanceof SchemaElementComplex)) {
            return false;
        }
        SchemaElementComplex complex = (SchemaElementComplex)item;
        return complex.getOptionalSimpleType() == null;
    }
}

