/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.DOMConvertingGetter;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.event.xml.SimpleXMLPropertyParser;
import com.espertech.esper.event.xml.XPathNamespaceContext;
import com.espertech.esper.event.xml.XPathPropertyGetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class SimpleXMLEventType
extends BaseXMLEventType {
    private static final Log log = LogFactory.getLog(SimpleXMLEventType.class);
    private final Map<String, EventPropertyGetter> propertyGetterCache;
    private String defaultNamespacePrefix;
    private final boolean isResolvePropertiesAbsolute;

    public SimpleXMLEventType(EventTypeMetadata eventTypeMetadata, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM, EventAdapterService eventAdapterService) {
        super(eventTypeMetadata, configurationEventTypeXMLDOM, eventAdapterService);
        this.isResolvePropertiesAbsolute = configurationEventTypeXMLDOM.isXPathResolvePropertiesAbsolute();
        XPathNamespaceContext xPathNamespaceContext = new XPathNamespaceContext();
        for (Map.Entry<String, String> entry : configurationEventTypeXMLDOM.getNamespacePrefixes().entrySet()) {
            xPathNamespaceContext.addPrefix(entry.getKey(), entry.getValue());
        }
        if (configurationEventTypeXMLDOM.getDefaultNamespace() != null) {
            String defaultNamespace = configurationEventTypeXMLDOM.getDefaultNamespace();
            xPathNamespaceContext.setDefaultNamespace(defaultNamespace);
            this.defaultNamespacePrefix = null;
            for (Map.Entry<String, String> entry : configurationEventTypeXMLDOM.getNamespacePrefixes().entrySet()) {
                if (!entry.getValue().equals(defaultNamespace)) continue;
                this.defaultNamespacePrefix = entry.getKey();
                break;
            }
        }
        super.setNamespaceContext(xPathNamespaceContext);
        super.initialize(configurationEventTypeXMLDOM.getXPathProperties().values(), Collections.EMPTY_LIST);
        this.propertyGetterCache = new HashMap<String, EventPropertyGetter>();
    }

    protected Class doResolvePropertyType(String propertyExpression) {
        Tree ast = PropertyParser.parse(propertyExpression);
        if (PropertyParser.isPropertyDynamic(ast)) {
            return Node.class;
        }
        return String.class;
    }

    protected EventPropertyGetter doResolvePropertyGetter(String propertyExpression) {
        EventPropertyGetter getter = this.propertyGetterCache.get(propertyExpression);
        if (getter != null) {
            return getter;
        }
        if (!this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr()) {
            Property prop = PropertyParser.parse(propertyExpression, false);
            getter = prop.getGetterDOM();
            if (!prop.isDynamic()) {
                getter = new DOMConvertingGetter(propertyExpression, (DOMPropertyGetter)getter, String.class);
            }
        } else {
            XPathExpression xPathExpression;
            String xPathExpr;
            boolean isDynamic;
            try {
                Tree ast = PropertyParser.parse(propertyExpression);
                isDynamic = PropertyParser.isPropertyDynamic(ast);
                xPathExpr = SimpleXMLPropertyParser.parse(ast, propertyExpression, this.getRootElementName(), this.defaultNamespacePrefix, this.isResolvePropertiesAbsolute);
                XPath xpath = this.getXPathFactory().newXPath();
                xpath.setNamespaceContext(this.namespaceContext);
                if (log.isInfoEnabled()) {
                    log.info("Compiling XPath expression for property '" + propertyExpression + "' as '" + xPathExpr + "'");
                }
                xPathExpression = xpath.compile(xPathExpr);
            }
            catch (XPathExpressionException e2) {
                throw new EPException("Error constructing XPath expression from property name '" + propertyExpression + '\'', e2);
            }
            QName xPathReturnType = isDynamic ? XPathConstants.NODE : XPathConstants.STRING;
            getter = new XPathPropertyGetter(propertyExpression, xPathExpr, xPathExpression, xPathReturnType, null, null);
        }
        this.propertyGetterCache.put(propertyExpression, getter);
        return getter;
    }

    protected FragmentEventType doResolveFragmentType(String property) {
        return null;
    }
}

