/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.StringValue;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleXMLPropertyParser {
    private static final Log log = LogFactory.getLog(SimpleXMLPropertyParser.class);

    public static String parse(Tree ast, String propertyName, String rootElementName, String defaultNamespacePrefix, boolean isResolvePropertiesAbsolute) {
        StringBuilder xPathBuf = new StringBuilder();
        xPathBuf.append('/');
        if (isResolvePropertiesAbsolute) {
            if (defaultNamespacePrefix != null) {
                xPathBuf.append(defaultNamespacePrefix);
                xPathBuf.append(':');
            }
            xPathBuf.append(rootElementName);
        }
        if (ast.getChildCount() == 1) {
            xPathBuf.append(SimpleXMLPropertyParser.makeProperty(ast.getChild(0), defaultNamespacePrefix));
        } else {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                xPathBuf.append(SimpleXMLPropertyParser.makeProperty(ast.getChild(i), defaultNamespacePrefix));
            }
        }
        String xPath = xPathBuf.toString();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".parse For property '" + propertyName + "' the xpath is '" + xPath + '\'');
        }
        return xPath;
    }

    private static String makeProperty(Tree child, String defaultNamespacePrefix) {
        String prefix = "";
        if (defaultNamespacePrefix != null) {
            prefix = defaultNamespacePrefix + ":";
        }
        switch (child.getType()) {
            case 162: 
            case 165: {
                return '/' + prefix + child.getChild(0).getText();
            }
            case 163: 
            case 167: {
                String key = StringValue.parseString(child.getChild(1).getText());
                return '/' + prefix + child.getChild(0).getText() + "[@id='" + key + "']";
            }
            case 164: 
            case 166: {
                int index = IntValue.parseString(child.getChild(1).getText());
                int xPathPosition = index + 1;
                return '/' + prefix + child.getChild(0).getText() + "[position() = " + xPathPosition + ']';
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }
}

