/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.xml.FragmentFactory;
import com.espertech.esper.event.xml.SchemaUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPropertyGetter
implements EventPropertyGetter {
    private static final Log log = LogFactory.getLog(XPathPropertyGetter.class);
    private final XPathExpression expression;
    private final String expressionText;
    private final String property;
    private final QName resultType;
    private final SimpleTypeParser simpleTypeParser;
    private final Class optionalCastToType;
    private final boolean isCastToArray;
    private final FragmentFactory fragmentFactory;

    public XPathPropertyGetter(String propertyName, String expressionText, XPathExpression xPathExpression, QName resultType, Class optionalCastToType, FragmentFactory fragmentFactory) {
        this.expression = xPathExpression;
        this.expressionText = expressionText;
        this.property = propertyName;
        this.resultType = resultType;
        this.fragmentFactory = fragmentFactory;
        if (optionalCastToType != null && optionalCastToType.isArray()) {
            this.isCastToArray = true;
            if (!resultType.equals(XPathConstants.NODESET)) {
                throw new IllegalArgumentException("Array cast-to types require XPathConstants.NODESET as the XPath result type");
            }
            optionalCastToType = optionalCastToType.getComponentType();
        } else {
            this.isCastToArray = false;
        }
        this.simpleTypeParser = optionalCastToType != null ? SimpleTypeParserFactory.getParser(optionalCastToType) : null;
        this.optionalCastToType = optionalCastToType == Node.class ? null : optionalCastToType;
    }

    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object und = eventBean.getUnderlying();
        if (und == null) {
            throw new PropertyAccessException("Unexpected null underlying event encountered, expecting org.w3c.dom.Node instance as underlying");
        }
        if (!(und instanceof Node)) {
            throw new PropertyAccessException("Unexpected underlying event of type '" + und.getClass() + "' encountered, expecting org.w3c.dom.Node as underlying");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Running XPath '" + this.expressionText + "' for property '" + this.property + "' against Node XML :" + SchemaUtil.serialize((Node)und));
            }
            if (this.optionalCastToType == null) {
                return this.expression.evaluate(und, this.resultType);
            }
            Object result = this.expression.evaluate(und, this.resultType);
            if (result == null) {
                return null;
            }
            if (this.isCastToArray) {
                return this.castToArray(result);
            }
            if (result instanceof String) {
                try {
                    return this.simpleTypeParser.parse(result.toString());
                }
                catch (RuntimeException ex) {
                    log.warn("Error parsing XPath property named '" + this.property + "' expression result '" + result + " as type " + this.optionalCastToType.getName());
                    return null;
                }
            }
            if (result instanceof Double) {
                try {
                    return JavaClassHelper.coerceBoxed((Number)result, this.optionalCastToType);
                }
                catch (RuntimeException ex) {
                    log.warn("Error coercing XPath property named '" + this.property + "' expression result '" + result + " as type " + this.optionalCastToType.getName());
                    return null;
                }
            }
            if (result instanceof Boolean) {
                if (this.optionalCastToType != Boolean.class) {
                    log.warn("Error coercing XPath property named '" + this.property + "' expression result '" + result + " as type " + this.optionalCastToType.getName());
                    return null;
                }
                return result;
            }
            log.warn("Error processing XPath property named '" + this.property + "' expression result '" + result + ", not a known type");
            return null;
        }
        catch (XPathExpressionException e2) {
            throw new PropertyAccessException("Error getting property " + this.property, e2);
        }
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    public Object getFragment(EventBean eventBean) {
        if (this.fragmentFactory == null) {
            return null;
        }
        Object und = eventBean.getUnderlying();
        if (und == null) {
            throw new PropertyAccessException("Unexpected null underlying event encountered, expecting org.w3c.dom.Node instance as underlying");
        }
        if (!(und instanceof Node)) {
            throw new PropertyAccessException("Unexpected underlying event of type '" + und.getClass() + "' encountered, expecting org.w3c.dom.Node as underlying");
        }
        try {
            Object result;
            if (log.isDebugEnabled()) {
                log.debug("Running XPath '" + this.expressionText + "' for property '" + this.property + "' against Node XML :" + SchemaUtil.serialize((Node)und));
            }
            if ((result = this.expression.evaluate(und, this.resultType)) instanceof Node) {
                return this.fragmentFactory.getEvent((Node)result);
            }
            if (result instanceof NodeList) {
                NodeList nodeList = (NodeList)result;
                EventBean[] events = new EventBean[nodeList.getLength()];
                for (int i = 0; i < events.length; ++i) {
                    events[i] = this.fragmentFactory.getEvent(nodeList.item(i));
                }
                return events;
            }
            log.warn("Error processing XPath property named '" + this.property + "' expression result is not of type Node or Nodeset");
            return null;
        }
        catch (XPathExpressionException e2) {
            throw new PropertyAccessException("Error getting property " + this.property, e2);
        }
    }

    private Object castToArray(Object result) {
        if (!(result instanceof NodeList)) {
            return null;
        }
        NodeList nodeList = (NodeList)result;
        Object array = Array.newInstance(this.optionalCastToType, nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object arrayItem;
            block4: {
                Node item = nodeList.item(i);
                if (item.getNodeType() != 1) continue;
                arrayItem = null;
                try {
                    String textContent = nodeList.item(i).getTextContent();
                    arrayItem = this.simpleTypeParser.parse(textContent);
                }
                catch (Exception ex) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info("Parse error for text content " + nodeList.item(i).getTextContent() + " for expression " + this.expression);
                }
            }
            Array.set(array, i, arrayItem);
        }
        return array;
    }
}

