/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.event.xml.NamespaceNamePair;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.util.ResourceLoader;
import com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl;
import com.sun.org.apache.xerces.internal.impl.dv.xs.XSSimpleTypeDecl;
import com.sun.org.apache.xerces.internal.xs.StringList;
import com.sun.org.apache.xerces.internal.xs.XSAttributeUse;
import com.sun.org.apache.xerces.internal.xs.XSComplexTypeDefinition;
import com.sun.org.apache.xerces.internal.xs.XSElementDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSFacet;
import com.sun.org.apache.xerces.internal.xs.XSImplementation;
import com.sun.org.apache.xerces.internal.xs.XSLoader;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import com.sun.org.apache.xerces.internal.xs.XSModelGroup;
import com.sun.org.apache.xerces.internal.xs.XSNamedMap;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSParticle;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDSchemaMapper {
    private static final Log log = LogFactory.getLog(XSDSchemaMapper.class);
    private static final int JAVA5_COMPLEX_TYPE = 13;
    private static final int JAVA5_SIMPLE_TYPE = 14;
    private static final int JAVA6_COMPLEX_TYPE = 15;
    private static final int JAVA6_SIMPLE_TYPE = 16;

    public static SchemaModel loadAndMap(String schemaResource, int maxRecusiveDepth) {
        XSModel model;
        try {
            model = XSDSchemaMapper.readSchemaInternal(schemaResource);
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to read schema '" + schemaResource + "' : " + ex.getMessage(), ex);
        }
        return XSDSchemaMapper.map(model, maxRecusiveDepth);
    }

    private static XSModel readSchemaInternal(String schemaResource) throws IllegalAccessException, InstantiationException, ClassNotFoundException, ConfigurationException, URISyntaxException {
        URL url = ResourceLoader.resolveClassPathOrURLResource("schema", schemaResource);
        String uri = url.toURI().toString();
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        registry.addSource(new DOMXSImplementationSourceImpl());
        XSImplementation impl = (XSImplementation)((Object)registry.getDOMImplementation("XS-Loader"));
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel xsModel = schemaLoader.loadURI(uri);
        if (xsModel == null) {
            throw new ConfigurationException("Failed to read schema via URL '" + schemaResource + '\'');
        }
        return xsModel;
    }

    private static SchemaModel map(XSModel xsModel, int maxRecusiveDepth) {
        StringList namespaces = xsModel.getNamespaces();
        ArrayList<String> namesspaceList = new ArrayList<String>();
        for (int i = 0; i < namespaces.getLength(); ++i) {
            namesspaceList.add(namespaces.item(i));
        }
        XSNamedMap elements = xsModel.getComponents((short)2);
        ArrayList<SchemaElementComplex> components = new ArrayList<SchemaElementComplex>();
        for (int i = 0; i < elements.getLength(); ++i) {
            XSElementDeclaration decl;
            XSObject object = elements.item(i);
            if (!(object instanceof XSElementDeclaration) || !XSDSchemaMapper.isComplexTypeCategory((decl = (XSElementDeclaration)elements.item(i)).getTypeDefinition().getTypeCategory())) continue;
            XSComplexTypeDefinition complexActualElement = (XSComplexTypeDefinition)decl.getTypeDefinition();
            String name = object.getName();
            String namespace2 = object.getNamespace();
            Stack<NamespaceNamePair> nameNamespaceStack = new Stack<NamespaceNamePair>();
            NamespaceNamePair nameNamespace = new NamespaceNamePair(namespace2, name);
            nameNamespaceStack.add(nameNamespace);
            if (log.isDebugEnabled()) {
                log.debug("Processing component " + namespace2 + " " + name);
            }
            SchemaElementComplex complexElement = XSDSchemaMapper.process(name, namespace2, complexActualElement, false, nameNamespaceStack, maxRecusiveDepth);
            if (log.isDebugEnabled()) {
                log.debug("Adding component " + namespace2 + " " + name);
            }
            components.add(complexElement);
        }
        return new SchemaModel(components, namesspaceList);
    }

    private static boolean isComplexTypeCategory(short typeCategory) {
        return typeCategory == 13 || typeCategory == 13 || typeCategory == 15;
    }

    private static boolean isSimpleTypeCategory(short typeCategory) {
        return typeCategory == 14 || typeCategory == 14 || typeCategory == 16;
    }

    private static SchemaElementComplex process(String complexElementName, String complexElementNamespace, XSComplexTypeDefinition complexActualElement, boolean isArray, Stack<NamespaceNamePair> nameNamespaceStack, int maxRecursiveDepth) {
        XSParticle particle;
        if (log.isDebugEnabled()) {
            log.debug("Processing complex " + complexElementNamespace + " " + complexElementName + " stack " + nameNamespaceStack);
        }
        ArrayList<SchemaItemAttribute> attributes = new ArrayList<SchemaItemAttribute>();
        ArrayList<SchemaElementSimple> simpleElements = new ArrayList<SchemaElementSimple>();
        ArrayList<SchemaElementComplex> complexElements = new ArrayList<SchemaElementComplex>();
        Short optionalSimplyType = null;
        String optionalSimplyTypeName = null;
        if (complexActualElement.getSimpleType() != null) {
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)complexActualElement.getSimpleType();
            optionalSimplyType = simpleType.getPrimitiveKind();
            optionalSimplyTypeName = simpleType.getName();
        }
        SchemaElementComplex complexElement = new SchemaElementComplex(complexElementName, complexElementNamespace, attributes, complexElements, simpleElements, isArray, optionalSimplyType, optionalSimplyTypeName);
        XSObjectList attrs = complexActualElement.getAttributeUses();
        for (int i = 0; i < attrs.getLength(); ++i) {
            XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
            String namespace2 = attr.getAttrDeclaration().getNamespace();
            String name = attr.getAttrDeclaration().getName();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)attr.getAttrDeclaration().getTypeDefinition();
            attributes.add(new SchemaItemAttribute(namespace2, name, simpleType.getPrimitiveKind(), simpleType.getName()));
        }
        if ((complexActualElement.getContentType() == 2 || complexActualElement.getContentType() == 3) && (particle = complexActualElement.getParticle()).getTerm() instanceof XSModelGroup) {
            XSModelGroup group = (XSModelGroup)particle.getTerm();
            XSObjectList particles = group.getParticles();
            for (int i = 0; i < particles.getLength(); ++i) {
                XSParticle childParticle = (XSParticle)particles.item(i);
                if (!(childParticle.getTerm() instanceof XSElementDeclaration)) continue;
                XSElementDeclaration decl = (XSElementDeclaration)childParticle.getTerm();
                boolean isArrayFlag = XSDSchemaMapper.isArray(childParticle);
                if (XSDSchemaMapper.isSimpleTypeCategory(decl.getTypeDefinition().getTypeCategory())) {
                    XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)decl.getTypeDefinition();
                    Integer fractionDigits = XSDSchemaMapper.getFractionRestriction(simpleType);
                    simpleElements.add(new SchemaElementSimple(decl.getName(), decl.getNamespace(), simpleType.getPrimitiveKind(), simpleType.getName(), isArrayFlag, fractionDigits));
                }
                if (!XSDSchemaMapper.isComplexTypeCategory(decl.getTypeDefinition().getTypeCategory())) continue;
                String name = decl.getName();
                String namespace3 = decl.getNamespace();
                NamespaceNamePair nameNamespace = new NamespaceNamePair(namespace3, name);
                nameNamespaceStack.add(nameNamespace);
                if (maxRecursiveDepth != Integer.MAX_VALUE) {
                    int containsCount = 0;
                    for (NamespaceNamePair pair : nameNamespaceStack) {
                        if (!nameNamespace.equals(pair)) continue;
                        ++containsCount;
                    }
                    if (containsCount >= maxRecursiveDepth) continue;
                }
                complexActualElement = (XSComplexTypeDefinition)decl.getTypeDefinition();
                SchemaElementComplex innerComplex = XSDSchemaMapper.process(name, namespace3, complexActualElement, isArrayFlag, nameNamespaceStack, maxRecursiveDepth);
                nameNamespaceStack.pop();
                if (log.isDebugEnabled()) {
                    log.debug("Adding complex " + complexElement);
                }
                complexElements.add(innerComplex);
            }
        }
        return complexElement;
    }

    private static Integer getFractionRestriction(XSSimpleTypeDecl simpleType) {
        if ((simpleType.getDefinedFacets() & 0x400) != 0) {
            XSObjectList facets = simpleType.getFacets();
            Integer digits = null;
            for (int f = 0; f < facets.getLength(); ++f) {
                XSFacet facet;
                XSObject item = facets.item(f);
                if (!(item instanceof XSFacet) || (facet = (XSFacet)item).getFacetKind() != 1024) continue;
                try {
                    digits = Integer.parseInt(facet.getLexicalFacetValue());
                    continue;
                }
                catch (RuntimeException ex) {
                    log.warn("Error parsing fraction facet value '" + facet.getLexicalFacetValue() + "' : " + ex.getMessage(), ex);
                }
            }
            return digits;
        }
        return null;
    }

    private static boolean isArray(XSParticle particle) {
        return particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
    }
}

