/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

public final class DoubleRange {
    private Double min;
    private Double max;
    private int hashCode;

    public DoubleRange(Double min2, Double max2) {
        this.min = min2;
        this.max = max2;
        if (min2 != null && max2 != null && min2 > max2) {
            this.max = min2;
            this.min = max2;
        }
        this.hashCode = 7;
        if (min2 != null) {
            this.hashCode = 31 * this.hashCode;
            this.hashCode ^= min2.hashCode();
        }
        if (max2 != null) {
            this.hashCode = 31 * this.hashCode;
            this.hashCode ^= max2.hashCode();
        }
    }

    public final Double getMin() {
        return this.min;
    }

    public final Double getMax() {
        return this.max;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DoubleRange)) {
            return false;
        }
        DoubleRange otherRange = (DoubleRange)other;
        return otherRange.max.doubleValue() == this.max.doubleValue() && otherRange.min.doubleValue() == this.min.doubleValue();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "DoubleRange min=" + this.min + " max=" + this.max;
    }
}

