/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterParamIndexBase;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterHandleSetNode
implements EventEvaluator {
    private final Set<FilterHandle> callbackSet = new LinkedHashSet<FilterHandle>();
    private final List<FilterParamIndexBase> indizes = new LinkedList<FilterParamIndexBase>();
    private final ReadWriteLock nodeRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterHandleSetNode.class);

    protected boolean isEmpty() {
        return this.callbackSet.isEmpty() && this.indizes.isEmpty();
    }

    protected int getFilterCallbackCount() {
        return this.callbackSet.size();
    }

    protected final ReadWriteLock getNodeRWLock() {
        return this.nodeRWLock;
    }

    public List<FilterParamIndexBase> getIndizes() {
        return this.indizes;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches, ExprEvaluatorContext exprEvaluatorContext) {
        this.nodeRWLock.readLock().lock();
        for (FilterParamIndexBase index : this.indizes) {
            index.matchEvent(eventBean, matches, exprEvaluatorContext);
        }
        for (FilterHandle filterCallback : this.callbackSet) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug(".match (" + Thread.currentThread().getId() + ") Found a match, filterCallbackHash=" + filterCallback.hashCode() + "  me=" + this + "  filterCallback=" + filterCallback);
            }
            matches.add(filterCallback);
        }
        this.nodeRWLock.readLock().unlock();
    }

    protected boolean contains(FilterHandle filterCallback) {
        return this.callbackSet.contains(filterCallback);
    }

    protected final void add(FilterParamIndexBase index) {
        this.indizes.add(index);
    }

    protected final boolean remove(FilterParamIndexBase index) {
        return this.indizes.remove(index);
    }

    protected final void add(FilterHandle filterCallback) {
        this.callbackSet.add(filterCallback);
    }

    protected final boolean remove(FilterHandle filterCallback) {
        return this.callbackSet.remove(filterCallback);
    }
}

