/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.filter.FilterSpecParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterParamExprMap {
    private Map<ExprNode, FilterSpecParam> exprNodes = new HashMap<ExprNode, FilterSpecParam>();
    private Map<FilterSpecParam, ExprNode> specParams = new HashMap<FilterSpecParam, ExprNode>();

    public void put(ExprNode exprNode, FilterSpecParam param) {
        this.exprNodes.put(exprNode, param);
        if (param != null) {
            this.specParams.put(param, exprNode);
        }
    }

    public List<ExprNode> getUnassignedExpressions() {
        ArrayList<ExprNode> unassigned = new ArrayList<ExprNode>();
        for (ExprNode exprNode : this.exprNodes.keySet()) {
            if (this.exprNodes.get(exprNode) != null) continue;
            unassigned.add(exprNode);
        }
        return unassigned;
    }

    public Collection<FilterSpecParam> getFilterParams() {
        return this.specParams.keySet();
    }

    public ExprNode removeEntry(FilterSpecParam param) {
        ExprNode exprNode = this.specParams.get(param);
        if (exprNode == null) {
            throw new IllegalStateException("Not found in collection param: " + param);
        }
        this.specParams.remove(param);
        this.exprNodes.remove(exprNode);
        return exprNode;
    }

    public void removeValue(FilterSpecParam param) {
        ExprNode exprNode = this.specParams.get(param);
        if (exprNode == null) {
            throw new IllegalStateException("Not found in collection param: " + param);
        }
        this.specParams.remove(param);
        this.exprNodes.put(exprNode, null);
    }
}

