/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexPropBase;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterParamIndexNotEquals
extends FilterParamIndexPropBase {
    private final Map<Object, EventEvaluator> constantsMap = new HashMap<Object, EventEvaluator>();
    private final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterParamIndexNotEquals.class);

    public FilterParamIndexNotEquals(String propertyName, EventType eventType) {
        super(propertyName, FilterOperator.NOT_EQUAL, eventType);
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        this.checkType(filterConstant);
        return this.constantsMap.get(filterConstant);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        this.checkType(filterConstant);
        this.constantsMap.put(filterConstant, evaluator);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        return this.constantsMap.remove(filterConstant) != null;
    }

    @Override
    public final int size() {
        return this.constantsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches, ExprEvaluatorContext exprEvaluatorContext) {
        Object attributeValue = this.getGetter().get(eventBean);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".match (" + Thread.currentThread().getId() + ") attributeValue=" + attributeValue);
        }
        this.constantsMapRWLock.readLock().lock();
        for (Object key : this.constantsMap.keySet()) {
            EventEvaluator evaluator;
            if (key == null) {
                if (attributeValue == null) continue;
                evaluator = this.constantsMap.get(null);
                evaluator.matchEvent(eventBean, matches, exprEvaluatorContext);
                continue;
            }
            if (attributeValue == null || key.equals(attributeValue)) continue;
            evaluator = this.constantsMap.get(key);
            evaluator.matchEvent(eventBean, matches, exprEvaluatorContext);
        }
        this.constantsMapRWLock.readLock().unlock();
    }

    private void checkType(Object filterConstant) {
        if (filterConstant != null && this.getPropertyBoxedType() != filterConstant.getClass()) {
            throw new IllegalArgumentException("Invalid type of filter constant of " + filterConstant.getClass().getName() + " for property " + this.getPropertyName());
        }
    }
}

