/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.EventTypeIndex;
import com.espertech.esper.filter.EventTypeIndexBuilder;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterServiceListener;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.filter.FilterSet;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.util.AuditPath;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterServiceImpl
implements FilterServiceSPI {
    private static final Log log = LogFactory.getLog(FilterServiceImpl.class);
    private final EventTypeIndexBuilder indexBuilder;
    private final EventTypeIndex eventTypeIndex;
    private final AtomicLong numEventsEvaluated = new AtomicLong();
    private volatile long filtersVersion = 1L;
    private final CopyOnWriteArraySet<FilterServiceListener> filterServiceListeners;

    protected FilterServiceImpl() {
        this.eventTypeIndex = new EventTypeIndex();
        this.indexBuilder = new EventTypeIndexBuilder(this.eventTypeIndex);
        this.filterServiceListeners = new CopyOnWriteArraySet();
    }

    @Override
    public long getFiltersVersion() {
        return this.filtersVersion;
    }

    @Override
    public void destroy() {
        log.debug("Destroying filter service");
        this.eventTypeIndex.destroy();
        this.indexBuilder.destroy();
    }

    @Override
    public final void add(FilterValueSet filterValueSet, FilterHandle filterCallback) {
        this.indexBuilder.add(filterValueSet, filterCallback);
        ++this.filtersVersion;
    }

    @Override
    public final void remove(FilterHandle filterCallback) {
        this.indexBuilder.remove(filterCallback);
        ++this.filtersVersion;
    }

    @Override
    public final long evaluate(EventBean eventBean, Collection<FilterHandle> matches, ExprEvaluatorContext exprEvaluatorContext) {
        long version2 = this.filtersVersion;
        this.numEventsEvaluated.incrementAndGet();
        this.eventTypeIndex.matchEvent(eventBean, matches, exprEvaluatorContext);
        if (AuditPath.isAuditEnabled && !this.filterServiceListeners.isEmpty()) {
            for (FilterServiceListener listener : this.filterServiceListeners) {
                listener.filtering(eventBean, matches, exprEvaluatorContext, null);
            }
        }
        return version2;
    }

    @Override
    public final long evaluate(EventBean eventBean, Collection<FilterHandle> matches, ExprEvaluatorContext exprEvaluatorContext, String statementId) {
        long version2 = this.filtersVersion;
        this.numEventsEvaluated.incrementAndGet();
        ArrayDequeJDK6Backport<FilterHandle> allMatches = new ArrayDequeJDK6Backport<FilterHandle>();
        this.eventTypeIndex.matchEvent(eventBean, allMatches, exprEvaluatorContext);
        for (FilterHandle match : allMatches) {
            if (!match.getStatementId().equals(statementId)) continue;
            matches.add(match);
        }
        if (AuditPath.isAuditEnabled && !this.filterServiceListeners.isEmpty()) {
            for (FilterServiceListener listener : this.filterServiceListeners) {
                listener.filtering(eventBean, matches, exprEvaluatorContext, statementId);
            }
        }
        return version2;
    }

    @Override
    public final long getNumEventsEvaluated() {
        return this.numEventsEvaluated.get();
    }

    @Override
    public void resetStats() {
        this.numEventsEvaluated.set(0L);
    }

    @Override
    public void addFilterServiceListener(FilterServiceListener filterServiceListener) {
        this.filterServiceListeners.add(filterServiceListener);
    }

    @Override
    public void removeFilterServiceListener(FilterServiceListener filterServiceListener) {
        this.filterServiceListeners.remove(filterServiceListener);
    }

    @Override
    public FilterSet take(Set<String> statementIds) {
        ++this.filtersVersion;
        return this.indexBuilder.take(statementIds);
    }

    @Override
    public void apply(FilterSet filterSet) {
        ++this.filtersVersion;
        this.indexBuilder.apply(filterSet);
    }
}

