/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamRangeValue;
import com.espertech.esper.pattern.MatchedEventMap;

public final class FilterSpecParamRange
extends FilterSpecParam {
    private final FilterSpecParamRangeValue min;
    private final FilterSpecParamRangeValue max;
    private static final long serialVersionUID = -3381167844631490119L;

    public FilterSpecParamRange(String propertyName, FilterOperator filterOperator, FilterSpecParamRangeValue min2, FilterSpecParamRangeValue max2) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        this.min = min2;
        this.max = max2;
        if (!filterOperator.isRangeOperator() && !filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "range filter parameter");
        }
    }

    public final Object getFilterValue(MatchedEventMap matchedEvents) {
        Double begin = this.min.getFilterValue(matchedEvents);
        Double end = this.max.getFilterValue(matchedEvents);
        return new DoubleRange(begin, end);
    }

    public FilterSpecParamRangeValue getMin() {
        return this.min;
    }

    public FilterSpecParamRangeValue getMax() {
        return this.max;
    }

    public final String toString() {
        return super.toString() + "  range=(min=" + this.min.toString() + ",max=" + this.max.toString() + ')';
    }

    public int getFilterHash() {
        return this.min.getFilterHash() + 31 * this.max.getFilterHash();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamRange)) {
            return false;
        }
        FilterSpecParamRange other = (FilterSpecParamRange)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.min.equals(other.min) && this.max.equals(other.max);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }
}

