/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryStateNode;
import com.espertech.esper.pattern.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.pattern.EvalFilterStateNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EvalEveryDistinctStateNode
extends EvalStateNode
implements Evaluator {
    private final Map<EvalStateNode, Set<MultiKeyUntyped>> spawnedNodes;
    private final MatchedEventMap beginState;
    private final PatternContext context;
    private final List<ExprNode> expressions;
    private final MatchedEventConvertor matchedEventConvertor;
    private static final Log log = LogFactory.getLog(EvalEveryStateNode.class);

    public EvalEveryDistinctStateNode(Evaluator parentNode, EvalEveryDistinctNode everyNode, MatchedEventMap beginState, PatternContext context, List<ExprNode> expressions, MatchedEventConvertor matchedEventConvertor) {
        super(everyNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.spawnedNodes = new LinkedHashMap<EvalStateNode, Set<MultiKeyUntyped>>();
        this.beginState = beginState.shallowCopy();
        this.context = context;
        this.expressions = expressions;
        this.matchedEventConvertor = matchedEventConvertor;
        EvalStateNode child = this.getFactoryNode().getChildNodes().get(0).newState(this, beginState, context, null);
        this.spawnedNodes.put(child, new HashSet());
    }

    @Override
    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting single child");
        }
        if (this.spawnedNodes.size() != 1) {
            throw new IllegalStateException("EVERY state node is expected to have single child state node");
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator();
        EvalStateNode child = this.spawnedNodes.keySet().iterator().next();
        child.setParentEvaluator(spawnEvaluator);
        child.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            child.quit();
        } else {
            child.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse");
        }
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalNode child = this.getFactoryNode().getChildNodes().get(0);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator();
        EvalStateNode spawned = child.newState(spawnEvaluator, this.beginState, this.context, null);
        spawned.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.put(spawned, new HashSet());
            spawned.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue fromNode=" + fromNode + "  isQuitted=" + isQuitted);
        }
        MultiKeyUntyped matchEventKey = this.getKeys(matchEvent);
        boolean haveSeenThis = false;
        Set<MultiKeyUntyped> keysFromNode = this.spawnedNodes.get(fromNode);
        if (keysFromNode != null) {
            if (keysFromNode.contains(matchEventKey)) {
                haveSeenThis = true;
            } else {
                keysFromNode.add(matchEventKey);
            }
        }
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!(fromNode instanceof EvalFilterStateNode)) {
            EvalNode child = this.getFactoryNode().getChildNodes().get(0);
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator();
            EvalStateNode spawned = child.newState(spawnEvaluator, this.beginState, this.context, null);
            spawned.start();
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                HashSet<MultiKeyUntyped> keyset = new HashSet<MultiKeyUntyped>();
                if (keysFromNode != null) {
                    keyset.addAll(keysFromNode);
                }
                this.spawnedNodes.put(spawned, keyset);
                spawned.setParentEvaluator(this);
            }
        }
        if (!haveSeenThis) {
            this.getParentEvaluator().evaluateTrue(matchEvent, this, false);
        }
    }

    @Override
    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Quitting EVERY-node all children");
        }
        for (EvalStateNode child : this.spawnedNodes.keySet()) {
            child.quit();
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode spawnedNode : this.spawnedNodes.keySet()) {
            spawnedNode.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }

    private MultiKeyUntyped getKeys(MatchedEventMap currentState) {
        EventBean[] eventsPerStream = this.matchedEventConvertor.convert(currentState);
        Object[] keys = new Object[this.expressions.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.expressions.get(i).evaluate(eventsPerStream, true, this.context);
        }
        return new MultiKeyUntyped(keys);
    }
}

