/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.pattern.EvalEveryDistinctStateNode;
import com.espertech.esper.pattern.EvalEveryStateNode;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalMatchUntilStateNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalFilterStateNode
extends EvalStateNode
implements FilterHandleCallback {
    private final EvalFilterNode evalFilterNode;
    private final MatchedEventMap beginState;
    private final PatternContext context;
    private boolean isStarted;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(EvalFilterStateNode.class);

    public EvalFilterStateNode(Evaluator parentNode, EvalFilterNode evalFilterNode, MatchedEventMap beginState, PatternContext context) {
        super(evalFilterNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.evalFilterNode = evalFilterNode;
        this.beginState = beginState;
        this.context = context;
    }

    public String getStatementId() {
        return this.context.getStatementId();
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting filter expression");
        }
        if (this.isStarted) {
            throw new IllegalStateException("Filter state node already active");
        }
        this.isStarted = true;
        this.startFiltering();
    }

    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Stop filter expression");
        }
        this.isStarted = false;
        this.stopFiltering();
    }

    private void evaluateTrue(MatchedEventMap event, boolean isQuitted) {
        this.getParentEvaluator().evaluateTrue(event, this, isQuitted);
    }

    public final void matchFound(EventBean event) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".matchFound Filter node received match");
        }
        if (!this.isStarted) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug(".matchFound Match ignored, filter was stopped");
            }
            return;
        }
        MatchedEventMap passUp = this.beginState.shallowCopy();
        if (this.evalFilterNode.getFilterSpec().getOptionalPropertyEvaluator() != null) {
            EventBean[] propertyEvents = this.evalFilterNode.getFilterSpec().getOptionalPropertyEvaluator().getProperty(event, this.context);
            if (propertyEvents == null) {
                return;
            }
            if (this.evalFilterNode.getEventAsName() != null) {
                passUp.add(this.evalFilterNode.getEventAsName(), propertyEvents);
            }
        } else if (this.evalFilterNode.getEventAsName() != null) {
            passUp.add(this.evalFilterNode.getEventAsName(), event);
        }
        boolean isQuitted = false;
        if (!(this.getParentEvaluator() instanceof EvalEveryStateNode || this.getParentEvaluator() instanceof EvalMatchUntilStateNode || this.getParentEvaluator() instanceof EvalEveryDistinctStateNode)) {
            this.stopFiltering();
            isQuitted = true;
        }
        this.evaluateTrue(passUp, isQuitted);
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        return data;
    }

    public boolean isSubSelect() {
        return false;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterStateNode");
        buffer.append(" tag=");
        buffer.append(this.evalFilterNode.getFilterSpec());
        buffer.append(" spec=");
        buffer.append(this.evalFilterNode.getFilterSpec());
        return buffer.toString();
    }

    private void startFiltering() {
        this.handle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), this);
        FilterValueSet filterValues = this.evalFilterNode.getFilterSpec().getValueSet(this.beginState);
        this.context.getFilterService().add(filterValues, this.handle);
        long filtersVersion = this.context.getFilterService().getFiltersVersion();
        this.context.getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }

    private void stopFiltering() {
        if (this.handle != null) {
            this.context.getFilterService().remove(this.handle);
        }
        this.handle = null;
        this.isStarted = false;
        long filtersVersion = this.context.getFilterService().getFiltersVersion();
        this.context.getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }
}

