/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;

public class EvalMatchUntilSpec
implements MetaDefItem,
Serializable {
    private final Integer lowerBounds;
    private final Integer upperBounds;
    private final boolean hasBounds;
    private final boolean isTightlyBound;
    private static final long serialVersionUID = -78885747872100470L;

    public EvalMatchUntilSpec(Integer lowerBounds, Integer upperBounds) {
        if (lowerBounds != null && lowerBounds < 0) {
            throw new IllegalArgumentException("Lower bounds in match-until cannot be a negative value");
        }
        if (upperBounds != null && upperBounds < 0) {
            throw new IllegalArgumentException("Upper bounds in match-until cannot be a negative value");
        }
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
        this.hasBounds = lowerBounds != null || upperBounds != null;
        if (lowerBounds != null && upperBounds != null) {
            if (lowerBounds > upperBounds) {
                throw new IllegalArgumentException("Lower bounds in match-until cannot be greater then the upper bounds");
            }
            this.isTightlyBound = lowerBounds.equals(upperBounds);
        } else {
            this.isTightlyBound = false;
        }
    }

    public boolean isBounded() {
        return this.hasBounds;
    }

    public boolean isTightlyBound() {
        return this.isTightlyBound;
    }

    public Integer getLowerBounds() {
        return this.lowerBounds;
    }

    public Integer getUpperBounds() {
        return this.upperBounds;
    }
}

