/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EvalMatchUntilStateNode
extends EvalStateNode
implements Evaluator {
    private final PatternContext context;
    private final HashMap<EvalStateNode, Integer> nodes;
    private final EvalMatchUntilNode evalMatchUntilNode;
    private final MatchedEventMap beginState;
    private final ArrayList<EventBean>[] matchedEventArrays;
    private EvalStateNode stateMatcher;
    private EvalStateNode stateUntil;
    private int numMatches;
    private static final Log log = LogFactory.getLog(EvalMatchUntilStateNode.class);

    public EvalMatchUntilStateNode(Evaluator parentNode, EvalMatchUntilNode evalMatchUntilNode, MatchedEventMap beginState, PatternContext context) {
        super(evalMatchUntilNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.context = context;
        this.nodes = new HashMap();
        this.beginState = beginState;
        this.matchedEventArrays = new ArrayList[evalMatchUntilNode.getTagsArrayed().length];
        this.evalMatchUntilNode = evalMatchUntilNode;
        EvalNode childMatcher = evalMatchUntilNode.getChildNodes().get(0);
        this.stateMatcher = childMatcher.newState(this, beginState, context, null);
        if (evalMatchUntilNode.getChildNodes().size() > 1) {
            EvalNode childUntil = evalMatchUntilNode.getChildNodes().get(1);
            this.stateUntil = childUntil.newState(this, beginState, context, null);
        }
    }

    @Override
    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting match-until expression - matcher");
        }
        if (this.stateUntil != null) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug(".start Starting match-until expression - until");
            }
            this.stateUntil.start();
        }
        if (this.stateMatcher != null) {
            this.stateMatcher.start();
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        MatchedEventMap consolidated;
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
            ++this.numMatches;
            String[] tags = this.evalMatchUntilNode.getTagsArrayed();
            for (int i = 0; i < tags.length; ++i) {
                Object event = matchEvent.getMatchingEventAsObject(tags[i]);
                if (event == null) continue;
                if (this.matchedEventArrays[i] == null) {
                    this.matchedEventArrays[i] = new ArrayList();
                }
                if (event instanceof EventBean) {
                    this.matchedEventArrays[i].add((EventBean)event);
                    continue;
                }
                EventBean[] arrayEvents = (EventBean[])event;
                this.matchedEventArrays[i].addAll(Arrays.asList(arrayEvents));
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue isMatcher=" + isMatcher + "  fromNode=" + fromNode.hashCode() + "  isQuitted=" + isQuitted);
        }
        if (isQuitted) {
            if (isMatcher) {
                this.stateMatcher = null;
            } else {
                this.stateUntil = null;
            }
        }
        if (isMatcher) {
            if (this.evalMatchUntilNode.getSpec().isTightlyBound() && this.numMatches == this.evalMatchUntilNode.getSpec().getLowerBounds()) {
                this.quit();
                consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getTagsArrayed());
                this.getParentEvaluator().evaluateTrue(consolidated, this, true);
            } else {
                boolean restart;
                boolean bl = restart = !this.evalMatchUntilNode.getSpec().isBounded() || this.evalMatchUntilNode.getSpec().getUpperBounds() == null || this.evalMatchUntilNode.getSpec().getUpperBounds() > this.numMatches;
                if (this.stateMatcher == null) {
                    if (restart) {
                        EvalNode childMatcher = this.evalMatchUntilNode.getChildNodes().get(0);
                        this.stateMatcher = childMatcher.newState(this, this.beginState, this.context, null);
                        this.stateMatcher.start();
                    }
                } else if (!restart) {
                    this.stateMatcher.quit();
                    this.stateMatcher = null;
                }
            }
        } else {
            this.quit();
            consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getTagsArrayed());
            if (this.evalMatchUntilNode.getSpec().getLowerBounds() != null && this.numMatches < this.evalMatchUntilNode.getSpec().getLowerBounds()) {
                this.getParentEvaluator().evaluateFalse(this);
            } else {
                this.getParentEvaluator().evaluateTrue(consolidated, this, true);
            }
        }
    }

    private static MatchedEventMap consolidate(MatchedEventMap beginState, ArrayList<EventBean>[] matchedEventList, String[] tagsArrayed) {
        if (tagsArrayed == null) {
            return beginState;
        }
        for (int i = 0; i < tagsArrayed.length; ++i) {
            if (matchedEventList[i] == null) continue;
            EventBean[] eventsForTag = matchedEventList[i].toArray(new EventBean[matchedEventList[i].size()]);
            beginState.add(tagsArrayed[i], eventsForTag);
        }
        return beginState;
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse Child node has indicated permanently false, isMatcher=" + isMatcher);
        }
        if (isMatcher) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        } else {
            this.stateUntil.quit();
            this.stateUntil = null;
            this.getParentEvaluator().evaluateFalse(this);
        }
    }

    @Override
    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Stopping match-until children");
        }
        if (this.stateMatcher != null) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        }
        if (this.stateUntil != null) {
            this.stateUntil.quit();
            this.stateUntil = null;
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalMatchUntilStateNode nodes=" + this.nodes.size();
    }
}

