/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalNotNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalNotStateNode
extends EvalStateNode
implements Evaluator {
    private final MatchedEventMap beginState;
    private EvalStateNode childNode;
    private static final Log log = LogFactory.getLog(EvalNotStateNode.class);

    public EvalNotStateNode(Evaluator parentNode, EvalNotNode evalNotNode, MatchedEventMap beginState, PatternContext context) {
        super(evalNotNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.beginState = beginState.shallowCopy();
        this.childNode = evalNotNode.getChildNodes().get(0).newState(this, beginState, context, null);
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting single child node");
        }
        if (this.childNode == null) {
            throw new IllegalStateException("'Not' state node is inactive");
        }
        this.childNode.start();
        this.getParentEvaluator().evaluateTrue(this.beginState, this, false);
    }

    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse");
        }
    }

    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue fromNode=" + fromNode.hashCode() + "  isQuitted=" + isQuitted);
        }
        if (isQuitted) {
            this.childNode = null;
            this.getParentEvaluator().evaluateFalse(this);
        }
    }

    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Quitting not-node single child, childNode=" + this.childNode);
        }
        if (this.childNode != null) {
            this.childNode.quit();
        }
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        this.childNode.accept(visitor, data);
        return data;
    }

    public final String toString() {
        return "EvalNotStateNode child=" + this.childNode;
    }
}

