/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternExpressionUtil {
    private static Log log = LogFactory.getLog(PatternExpressionUtil.class);

    public static List<Object> evaluate(String objectName, MatchedEventMap beginState, List<ExprNode> parameters, MatchedEventConvertor convertor, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        ArrayList<Object> results = new ArrayList<Object>();
        int count = 0;
        EventBean[] eventsPerStream = convertor.convert(beginState);
        for (ExprNode expr : parameters) {
            try {
                Object result = PatternExpressionUtil.evaluate(objectName, expr, eventsPerStream, exprEvaluatorContext);
                results.add(result);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = objectName + " invalid parameter in expression " + count;
                if (ex.getMessage() != null) {
                    message = message + ": " + ex.getMessage();
                }
                log.error(message, ex);
                throw new EPException(message);
            }
        }
        return results;
    }

    public static Object evaluate(String objectName, MatchedEventMap beginState, ExprNode parameter, MatchedEventConvertor convertor, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        EventBean[] eventsPerStream = convertor.convert(beginState);
        return PatternExpressionUtil.evaluate(objectName, parameter, eventsPerStream, exprEvaluatorContext);
    }

    private static Object evaluate(String objectName, ExprNode expression, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        try {
            return expression.evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            String message = objectName + " failed to evaluate expression";
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error(message, ex);
            throw new EPException(message);
        }
    }
}

