/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.spec.ObjectSpec;
import com.espertech.esper.epl.spec.PatternGuardSpec;
import com.espertech.esper.epl.spec.PatternObserverSpec;
import com.espertech.esper.epl.spec.PluggableObjectCollection;
import com.espertech.esper.epl.spec.PluggableObjectType;
import com.espertech.esper.pattern.PatternObjectException;
import com.espertech.esper.pattern.PatternObjectResolutionService;
import com.espertech.esper.pattern.guard.GuardFactory;
import com.espertech.esper.pattern.observer.ObserverFactory;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatternObjectResolutionServiceImpl
implements PatternObjectResolutionService {
    private static final Log log = LogFactory.getLog(PatternObjectResolutionServiceImpl.class);
    private final PluggableObjectCollection patternObjects;

    public PatternObjectResolutionServiceImpl(PluggableObjectCollection patternObjects) {
        this.patternObjects = patternObjects;
    }

    public ObserverFactory create(PatternObserverSpec spec) throws PatternObjectException {
        ObserverFactory factory;
        Object result = this.createFactory(spec, PluggableObjectType.PATTERN_OBSERVER);
        try {
            factory = (ObserverFactory)result;
            if (log.isDebugEnabled()) {
                log.debug(".create Successfully instantiated observer");
            }
        }
        catch (ClassCastException e2) {
            String message = "Error casting observer factory instance to " + ObserverFactory.class.getName() + " interface for observer '" + spec.getObjectName() + "'";
            throw new PatternObjectException(message, e2);
        }
        return factory;
    }

    public GuardFactory create(PatternGuardSpec spec) throws PatternObjectException {
        GuardFactory factory;
        Object result = this.createFactory(spec, PluggableObjectType.PATTERN_GUARD);
        try {
            factory = (GuardFactory)result;
            if (log.isDebugEnabled()) {
                log.debug(".create Successfully instantiated guard");
            }
        }
        catch (ClassCastException e2) {
            String message = "Error casting guard factory instance to " + GuardFactory.class.getName() + " interface for guard '" + spec.getObjectName() + "'";
            throw new PatternObjectException(message, e2);
        }
        return factory;
    }

    private Object createFactory(ObjectSpec spec, PluggableObjectType type) throws PatternObjectException {
        Object result;
        Pair<Class, PluggableObjectType> pair;
        if (log.isDebugEnabled()) {
            log.debug(".create Creating factory, spec=" + spec.toString());
        }
        Class factoryClass = null;
        Map<String, Pair<Class, PluggableObjectType>> namespaceMap = this.patternObjects.getPluggables().get(spec.getObjectNamespace());
        if (namespaceMap != null && (pair = namespaceMap.get(spec.getObjectName())) != null) {
            if (pair.getSecond() == type) {
                factoryClass = pair.getFirst();
            } else {
                if (type == PluggableObjectType.PATTERN_GUARD) {
                    throw new PatternObjectException("Pattern observer function '" + spec.getObjectName() + "' cannot be used as a pattern guard");
                }
                throw new PatternObjectException("Pattern guard function '" + spec.getObjectName() + "' cannot be used as a pattern observer");
            }
        }
        if (factoryClass == null) {
            String message;
            if (type == PluggableObjectType.PATTERN_GUARD) {
                message = "Pattern guard name '" + spec.getObjectName() + "' is not a known pattern object name";
                throw new PatternObjectException(message);
            }
            if (type == PluggableObjectType.PATTERN_OBSERVER) {
                message = "Pattern observer name '" + spec.getObjectName() + "' is not a known pattern object name";
                throw new PatternObjectException(message);
            }
            throw new PatternObjectException("Pattern object type '" + (Object)((Object)type) + "' not known");
        }
        try {
            result = factoryClass.newInstance();
        }
        catch (IllegalAccessException e2) {
            String message = "Error invoking pattern object factory constructor for object '" + spec.getObjectName();
            message = message + "', no invocation access for Class.newInstance";
            throw new PatternObjectException(message, e2);
        }
        catch (InstantiationException e3) {
            String message = "Error invoking pattern object factory constructor for object '" + spec.getObjectName();
            message = message + "' using Class.newInstance";
            throw new PatternObjectException(message, e3);
        }
        return result;
    }
}

