/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.Quitable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionGuard
implements Guard {
    private static Log log = LogFactory.getLog(ExpressionGuard.class);
    private final PatternContext context;
    private final Quitable quitable;
    private final MatchedEventConvertor convertor;
    private final ExprNode expression;

    public ExpressionGuard(MatchedEventConvertor convertor, ExprNode expression, PatternContext context, Quitable quitable) {
        this.context = context;
        this.quitable = quitable;
        this.convertor = convertor;
        this.expression = expression;
    }

    public void startGuard() {
    }

    public boolean inspect(MatchedEventMap matchEvent) {
        EventBean[] eventsPerStream = this.convertor.convert(matchEvent);
        try {
            Object result = this.expression.evaluate(eventsPerStream, true, this.context);
            if (result == null) {
                return false;
            }
            if (result.equals(Boolean.TRUE)) {
                return true;
            }
            this.quitable.guardQuit();
            return false;
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate expression for pattern-guard for statement '" + this.context.getStatementName() + "'";
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error(message, ex);
            throw new EPException(message);
        }
    }

    public void stopGuard() {
    }
}

