/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.guard.ExpressionGuard;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.GuardFactory;
import com.espertech.esper.pattern.guard.GuardParameterException;
import com.espertech.esper.pattern.guard.Quitable;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionGuardFactory
implements GuardFactory,
MetaDefItem,
Serializable {
    private static final long serialVersionUID = -5107582730824731419L;
    protected ExprNode expression;
    protected transient MatchedEventConvertor convertor;

    @Override
    public void setGuardParameters(List<ExprNode> params, MatchedEventConvertor convertor) throws GuardParameterException {
        String errorMessage = "Expression pattern guard requires a single expression as a parameter returning a true or false (boolean) value";
        if (params.size() != 1) {
            throw new GuardParameterException(errorMessage);
        }
        this.expression = params.get(0);
        if (JavaClassHelper.getBoxedType(params.get(0).getType()) != Boolean.class) {
            throw new GuardParameterException(errorMessage);
        }
        this.convertor = convertor;
    }

    @Override
    public Guard makeGuard(PatternContext context, MatchedEventMap matchedEventMap, Quitable quitable, Object stateNodeId, Object guardState) {
        return new ExpressionGuard(this.convertor, this.expression, context, quitable);
    }
}

