/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.PatternExpressionUtil;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.GuardFactory;
import com.espertech.esper.pattern.guard.GuardParameterException;
import com.espertech.esper.pattern.guard.Quitable;
import com.espertech.esper.pattern.guard.TimerWithinOrMaxCountGuard;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerWithinOrMaxCountGuardFactory
implements GuardFactory,
MetaDefItem,
Serializable {
    private static final long serialVersionUID = 6650243610865501435L;
    protected ExprNode millisecondsExpr;
    protected ExprNode numCountToExpr;
    protected transient MatchedEventConvertor convertor;

    @Override
    public void setGuardParameters(List<ExprNode> params, MatchedEventConvertor convertor) throws GuardParameterException {
        String message = "Timer-within-or-max-count guard requires two parameters: numeric or time period parameter and an integer-value expression parameter";
        if (params.size() != 2) {
            throw new GuardParameterException(message);
        }
        if (!JavaClassHelper.isNumeric(params.get(0).getType())) {
            throw new GuardParameterException(message);
        }
        if (params.get(1).getType() != Integer.class) {
            throw new GuardParameterException(message);
        }
        this.millisecondsExpr = params.get(0);
        this.numCountToExpr = params.get(1);
        this.convertor = convertor;
    }

    @Override
    public Guard makeGuard(PatternContext context, MatchedEventMap matchedEventMap, Quitable quitable, Object stateNodeId, Object guardState) {
        Object millisecondVal = PatternExpressionUtil.evaluate("Timer-Within-Or-Max-Count guard", matchedEventMap, this.millisecondsExpr, this.convertor, (ExprEvaluatorContext)context);
        if (null == millisecondVal) {
            throw new EPException("Timer-within-or-max first parameter evaluated to a null-value");
        }
        Number param = (Number)millisecondVal;
        long milliseconds = Math.round(1000.0 * param.doubleValue());
        Object numCountToVal = PatternExpressionUtil.evaluate("Timer-Within-Or-Max-Count guard", matchedEventMap, this.numCountToExpr, this.convertor, (ExprEvaluatorContext)context);
        if (null == numCountToVal) {
            throw new EPException("Timer-within-or-max second parameter evaluated to a null-value");
        }
        Integer numCountTo = (Integer)numCountToVal;
        return new TimerWithinOrMaxCountGuard(milliseconds, numCountTo, context, quitable);
    }
}

