/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;

public class TimerIntervalObserver
implements EventObserver,
ScheduleHandleCallback {
    private final long msec;
    private final PatternContext context;
    private final MatchedEventMap beginState;
    private final ObserverEventEvaluator observerEventEvaluator;
    private final ScheduleSlot scheduleSlot;
    private boolean isTimerActive = false;
    private EPStatementHandleCallback scheduleHandle;

    public TimerIntervalObserver(long msec, PatternContext context, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator) {
        this.msec = msec;
        this.context = context;
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = context.getScheduleBucket().allocateSlot();
    }

    public final void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState);
        this.isTimerActive = false;
    }

    public void startObserve() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        if (this.msec <= 0L) {
            this.observerEventEvaluator.observerEvaluateTrue(this.beginState);
        } else {
            this.scheduleHandle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), this);
            this.context.getSchedulingService().add(this.msec, (ScheduleHandle)this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = true;
        }
    }

    public void stopObserve() {
        if (this.isTimerActive) {
            this.context.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = false;
            this.scheduleHandle = null;
        }
    }
}

