/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.schedule.ScheduleCalendar;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.type.ScheduleUnit;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScheduleComputeHelper {
    private static final int MIN_OFFSET_MSEC = 1000;
    private static final Log log = LogFactory.getLog(ScheduleComputeHelper.class);

    public static long computeNextOccurance(ScheduleSpec spec, long afterTimeInMillis) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".computeNextOccurance Computing next occurance, afterTimeInMillis=" + new Date(afterTimeInMillis) + "  as long=" + afterTimeInMillis + "  spec=" + spec);
        }
        afterTimeInMillis = spec.getUnitValues().containsKey((Object)ScheduleUnit.SECONDS) ? (afterTimeInMillis += 1000L) : (afterTimeInMillis += 60000L);
        Date result = ScheduleComputeHelper.compute(spec, afterTimeInMillis);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".computeNextOccurance Completed, result=" + result + "  long=" + result.getTime());
        }
        return result.getTime();
    }

    private static Date compute(ScheduleSpec spec, long afterTimeInMillis) {
        ScheduleCalendar result;
        Calendar after;
        while (true) {
            after = Calendar.getInstance();
            after.setTimeInMillis(afterTimeInMillis);
            result = new ScheduleCalendar();
            result.setMilliseconds(after.get(14));
            SortedSet<Integer> minutesSet = spec.getUnitValues().get((Object)ScheduleUnit.MINUTES);
            SortedSet<Integer> hoursSet = spec.getUnitValues().get((Object)ScheduleUnit.HOURS);
            SortedSet<Integer> monthsSet = spec.getUnitValues().get((Object)ScheduleUnit.MONTHS);
            SortedSet<Integer> secondsSet = null;
            boolean isSecondsSpecified = false;
            if (spec.getUnitValues().containsKey((Object)ScheduleUnit.SECONDS)) {
                isSecondsSpecified = true;
                secondsSet = spec.getUnitValues().get((Object)ScheduleUnit.SECONDS);
            }
            if (isSecondsSpecified) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, after.get(13)));
                if (result.getSecond() == -1) {
                    result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                    after.add(12, 1);
                }
            }
            result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, after.get(12)));
            if (result.getMinute() != after.get(12)) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
            }
            if (result.getMinute() == -1) {
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                after.add(11, 1);
            }
            result.setHour(ScheduleComputeHelper.nextValue(hoursSet, after.get(11)));
            if (result.getHour() != after.get(11)) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
            }
            if (result.getHour() == -1) {
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                after.add(5, 1);
            }
            result.setDayOfMonth(ScheduleComputeHelper.determineDayOfMonth(spec, after, result));
            boolean dayMatchRealDate = false;
            while (!dayMatchRealDate) {
                if (ScheduleComputeHelper.checkDayValidInMonth(result.getDayOfMonth(), after.get(2), after.get(1))) {
                    dayMatchRealDate = true;
                    continue;
                }
                after.add(2, 1);
            }
            int currentMonth = after.get(2) + 1;
            result.setMonth(ScheduleComputeHelper.nextValue(monthsSet, currentMonth));
            if (result.getMonth() != currentMonth) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                result.setDayOfMonth(ScheduleComputeHelper.determineDayOfMonth(spec, after, result));
            }
            if (result.getMonth() == -1) {
                result.setMonth(ScheduleComputeHelper.nextValue(monthsSet, 0));
                after.add(1, 1);
            }
            int year = after.get(1);
            if (ScheduleComputeHelper.checkDayValidInMonth(result.getDayOfMonth(), result.getMonth() - 1, year)) break;
            afterTimeInMillis = after.getTimeInMillis();
        }
        return ScheduleComputeHelper.getTime(result, after.get(1));
    }

    private static int determineDayOfMonth(ScheduleSpec spec, Calendar after, ScheduleCalendar result) {
        int dayOfMonth;
        SortedSet<Integer> daysOfMonthSet = spec.getUnitValues().get((Object)ScheduleUnit.DAYS_OF_MONTH);
        SortedSet<Integer> daysOfWeekSet = spec.getUnitValues().get((Object)ScheduleUnit.DAYS_OF_WEEK);
        SortedSet<Integer> secondsSet = spec.getUnitValues().get((Object)ScheduleUnit.SECONDS);
        SortedSet<Integer> minutesSet = spec.getUnitValues().get((Object)ScheduleUnit.MINUTES);
        SortedSet<Integer> hoursSet = spec.getUnitValues().get((Object)ScheduleUnit.HOURS);
        if (daysOfWeekSet == null) {
            dayOfMonth = ScheduleComputeHelper.nextValue(daysOfMonthSet, after.get(5));
            if (dayOfMonth != after.get(5)) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
            }
            if (dayOfMonth == -1) {
                dayOfMonth = ScheduleComputeHelper.nextValue(daysOfMonthSet, 0);
                after.add(2, 1);
            }
        } else if (daysOfMonthSet == null) {
            while (true) {
                dayOfMonth = after.get(5);
                int dayOfWeek = after.get(7) - 1;
                if (!daysOfWeekSet.contains(dayOfWeek)) {
                    result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                    result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                    result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                    after.add(5, 1);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                dayOfMonth = after.get(5);
                int dayOfWeek = after.get(7) - 1;
                if (daysOfWeekSet.contains(dayOfWeek) || daysOfMonthSet.contains(dayOfMonth)) break;
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                after.add(5, 1);
            }
        }
        return dayOfMonth;
    }

    private static Date getTime(ScheduleCalendar result, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, result.getMonth() - 1, result.getDayOfMonth(), result.getHour(), result.getMinute(), result.getSecond());
        calendar.set(14, result.getMilliseconds());
        return calendar.getTime();
    }

    private static boolean checkDayValidInMonth(int day, int month, int year) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, day);
            calendar.getTime();
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
        return true;
    }

    private static int nextValue(SortedSet<Integer> valueSet, int startValue) {
        if (valueSet == null) {
            return startValue;
        }
        if (valueSet.contains(startValue)) {
            return startValue;
        }
        SortedSet<Integer> tailSet = valueSet.tailSet(startValue + 1);
        if (tailSet.isEmpty()) {
            return -1;
        }
        return tailSet.first();
    }
}

