/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.schedule.ScheduleParameterException;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.type.CronParameter;
import com.espertech.esper.type.NumberSetParameter;
import com.espertech.esper.type.ScheduleUnit;
import java.util.EnumMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleSpecUtil {
    public static ScheduleSpec computeValues(Object[] args) throws ScheduleParameterException {
        EnumMap<ScheduleUnit, SortedSet<Integer>> unitMap = new EnumMap<ScheduleUnit, SortedSet<Integer>>(ScheduleUnit.class);
        Object minutes = args[0];
        Object hours = args[1];
        Object daysOfMonth = args[2];
        Object months = args[3];
        Object daysOfWeek = args[4];
        unitMap.put(ScheduleUnit.MINUTES, ScheduleSpecUtil.computeValues(minutes, ScheduleUnit.MINUTES));
        unitMap.put(ScheduleUnit.HOURS, ScheduleSpecUtil.computeValues(hours, ScheduleUnit.HOURS));
        SortedSet<Integer> resultMonths = ScheduleSpecUtil.computeValues(months, ScheduleUnit.MONTHS);
        if (daysOfWeek instanceof CronParameter && daysOfMonth instanceof CronParameter) {
            throw new ScheduleParameterException("Invalid combination between days of week and days of month fields for timer:at");
        }
        if (resultMonths != null && resultMonths.size() == 1 && resultMonths.first() instanceof Integer) {
            CronParameter parameter = null;
            if (daysOfMonth instanceof CronParameter) {
                parameter = (CronParameter)daysOfMonth;
            } else if (daysOfWeek instanceof CronParameter) {
                parameter = (CronParameter)daysOfWeek;
            }
            if (parameter != null) {
                parameter.setMonth(resultMonths.first());
            }
        }
        SortedSet<Integer> resultDaysOfWeek = ScheduleSpecUtil.computeValues(daysOfWeek, ScheduleUnit.DAYS_OF_WEEK);
        SortedSet<Integer> resultDaysOfMonth = ScheduleSpecUtil.computeValues(daysOfMonth, ScheduleUnit.DAYS_OF_MONTH);
        if (resultDaysOfWeek != null && resultDaysOfWeek.size() == 1 && resultDaysOfWeek.first() instanceof Integer && resultDaysOfWeek.first() > 6) {
            if (resultDaysOfMonth != null) {
                throw new ScheduleParameterException("Invalid combination between days of week and days of month fields for timer:at");
            }
            resultDaysOfMonth = resultDaysOfWeek;
            resultDaysOfWeek = null;
        }
        if (resultDaysOfMonth != null && resultDaysOfMonth.size() == 1 && resultDaysOfMonth.first() instanceof Integer && resultDaysOfWeek != null) {
            throw new ScheduleParameterException("Invalid combination between days of week and days of month fields for timer:at");
        }
        unitMap.put(ScheduleUnit.DAYS_OF_WEEK, resultDaysOfWeek);
        unitMap.put(ScheduleUnit.DAYS_OF_MONTH, resultDaysOfMonth);
        unitMap.put(ScheduleUnit.MONTHS, resultMonths);
        if (args.length > 5) {
            unitMap.put(ScheduleUnit.SECONDS, ScheduleSpecUtil.computeValues(args[5], ScheduleUnit.SECONDS));
        }
        return new ScheduleSpec(unitMap);
    }

    private static SortedSet<Integer> computeValues(Object unitParameter, ScheduleUnit unit) throws ScheduleParameterException {
        if (unitParameter instanceof Integer) {
            TreeSet<Integer> result = new TreeSet<Integer>();
            result.add((Integer)unitParameter);
            return result;
        }
        NumberSetParameter numberSet = (NumberSetParameter)unitParameter;
        if (numberSet.isWildcard(unit.min(), unit.min())) {
            return null;
        }
        Set<Integer> result = numberSet.getValuesInRange(unit.min(), unit.max());
        TreeSet<Integer> resultSorted = new TreeSet<Integer>();
        resultSorted.addAll(result);
        return resultSorted;
    }
}

