/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.timer;

import com.espertech.esper.timer.TimerCallback;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EPLTimerTask
implements Runnable {
    private static final Log log = LogFactory.getLog(EPLTimerTask.class);
    private final TimerCallback callback;
    private ScheduledFuture<?> future;
    private boolean isCancelled;
    protected boolean _enableStats;
    protected long _lastDrift;
    protected long _maxDrift;
    protected long _totalDrift;
    protected long _invocationCount;

    public EPLTimerTask(TimerCallback callback) {
        this.callback = callback;
        this._enableStats = false;
        this._lastDrift = 0L;
        this._maxDrift = 0L;
        this._totalDrift = 0L;
        this._invocationCount = 0L;
    }

    @Override
    public final void run() {
        if (!this.isCancelled) {
            if (this._enableStats) {
                if (this.future != null) {
                    this._lastDrift = Math.abs(this.future.getDelay(TimeUnit.MILLISECONDS));
                }
                this._totalDrift += this._lastDrift;
                ++this._invocationCount;
                if (this._lastDrift > this._maxDrift) {
                    this._maxDrift = this._lastDrift;
                }
            }
            try {
                this.callback.timerCallback();
            }
            catch (Throwable t) {
                log.error("Timer thread caught unhandled exception: " + t.getMessage(), t);
            }
        }
    }

    protected void resetStats() {
        this._invocationCount = 0L;
        this._lastDrift = 0L;
        this._totalDrift = 0L;
        this._maxDrift = 0L;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }
}

