/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.NumberSetParameter;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronParameter
implements NumberSetParameter {
    private CronOperatorEnum operator;
    private Calendar calendar;
    private Integer day;
    private Integer month;
    private static int FIRST_DAY_OF_WEEK = 1;
    private static final long serialVersionUID = -4006350378033980878L;

    public CronParameter(CronOperatorEnum operator, Integer day, long engineTime) {
        this.operator = operator;
        this.day = day;
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(engineTime);
        this.calendar.setFirstDayOfWeek(FIRST_DAY_OF_WEEK);
    }

    public void setMonth(int month) {
        this.month = month - 1;
    }

    @Override
    public boolean isWildcard(int min2, int max2) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<Integer> getValuesInRange(int min2, int max2) {
        HashSet<Integer> values = new HashSet<Integer>();
        if (min2 != 0 && min2 != 1 || max2 != 6 && max2 != 31) {
            throw new IllegalArgumentException("Invalid usage for timer:at");
        }
        if (this.operator == CronOperatorEnum.LASTDAY) {
            if (min2 == 0 && max2 == 6) {
                if (this.day == null) {
                    values.add(this.determineLastDayOfWeek());
                    return values;
                } else {
                    values.add(this.determineLastDayOfWeekInMonth());
                }
                return values;
            } else {
                if (min2 != 1 || max2 != 31) throw new IllegalArgumentException("Invalid value for last operator");
                if (this.day == null) {
                    values.add(this.determineLastDayOfMonth());
                    return values;
                } else {
                    values.add(this.determineLastDayOfWeekInMonth());
                }
            }
            return values;
        } else if (this.operator == CronOperatorEnum.LASTWEEKDAY) {
            values.add(this.determineLastWeekDayOfMonth());
            return values;
        } else {
            if (this.operator != CronOperatorEnum.WEEKDAY) throw new IllegalArgumentException("Invalid special operator for observer");
            values.add(this.determineLastWeekDayOfMonth());
        }
        return values;
    }

    private int determineLastDayOfMonth() {
        this.setTime();
        this.calendar.set(5, this.calendar.getActualMaximum(5));
        return this.calendar.get(5);
    }

    private int determineLastDayOfWeekInMonth() {
        if (this.day == null) {
            return this.determineLastDayOfMonth();
        }
        if (this.day < 0 || this.day > 7) {
            throw new IllegalArgumentException("Last xx day of the month has to be a day of week (0-7)");
        }
        int dayOfWeek = this.getDayOfWeek();
        this.setTime();
        this.calendar.set(5, this.calendar.getActualMaximum(5));
        int dayDiff = this.calendar.get(7) - dayOfWeek;
        if (dayDiff > 0) {
            this.calendar.add(7, -dayDiff);
        } else if (dayDiff < 0) {
            this.calendar.add(7, -7 - dayDiff);
        }
        return this.calendar.get(5);
    }

    private int determineLastDayOfWeek() {
        this.setTime();
        this.calendar.set(7, 7);
        return this.calendar.get(7) - 1;
    }

    private int getDayOfWeek() {
        this.setTime();
        if (this.day == null) {
            this.calendar.set(7, 7);
        } else {
            this.calendar.set(7, this.day + 1);
        }
        return this.calendar.get(7);
    }

    private int determineLastWeekDayOfMonth() {
        int computeDay = this.day == null ? this.determineLastDayOfMonth() : this.day.intValue();
        this.setTime();
        if (!CronParameter.checkDayValidInMonth(computeDay, this.calendar.get(2), this.calendar.get(1))) {
            throw new IllegalArgumentException("Invalid day for " + this.calendar.get(2));
        }
        this.calendar.set(5, computeDay);
        int dayOfWeek = this.calendar.get(7);
        if (dayOfWeek >= 2 && dayOfWeek <= 6) {
            return computeDay;
        }
        if (dayOfWeek == 7) {
            if (computeDay == 1) {
                this.calendar.add(5, 2);
            } else {
                this.calendar.add(5, -1);
            }
        }
        if (dayOfWeek == 1) {
            if (computeDay == 28 || computeDay == 29 || computeDay == 30 || computeDay == 31) {
                this.calendar.add(5, -2);
            } else {
                this.calendar.add(5, 2);
            }
        }
        return this.calendar.get(5);
    }

    private static boolean checkDayValidInMonth(int day, int month, int year) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, day);
            calendar.getTime();
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
        return true;
    }

    private void setTime() {
        this.calendar.set(5, 1);
        if (this.month != null) {
            this.calendar.set(2, this.month);
        }
    }
}

