/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.type.NumberSetParameter;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyParameter
implements NumberSetParameter {
    private int frequency;
    private static final long serialVersionUID = -2303214112045704231L;

    public FrequencyParameter(int frequency) {
        this.frequency = frequency;
        if (frequency <= 0) {
            throw new IllegalArgumentException("Zero or negative value supplied as freqeuncy");
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public boolean isWildcard(int min2, int max2) {
        return this.frequency == 1;
    }

    @Override
    public Set<Integer> getValuesInRange(int min2, int max2) {
        HashSet<Integer> values = new HashSet<Integer>();
        int start = min2 - min2 % this.frequency;
        do {
            if (start < min2) continue;
            values.add(start);
        } while ((start += this.frequency) <= max2);
        return values;
    }
}

