/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.util.DatabaseTypeBinding;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseTypeEnum {
    String(String.class),
    BigDecimal(BigDecimal.class),
    Boolean(Boolean.class),
    Byte(Byte.class),
    Short(Short.class),
    Int(Integer.class),
    Long(Long.class),
    Float(Float.class),
    Double(Double.class),
    ByteArray(byte[].class),
    SqlDate(Date.class),
    SqlTime(Time.class),
    SqlTimestamp(Timestamp.class);

    private Class javaClass;
    private static Map<DatabaseTypeEnum, DatabaseTypeBinding> bindings;

    private DatabaseTypeEnum(Class javaClass) {
        this.javaClass = javaClass;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public static DatabaseTypeEnum getEnum(String type) {
        String boxedType = JavaClassHelper.getBoxedClassName(type);
        for (DatabaseTypeEnum val : DatabaseTypeEnum.values()) {
            if (val.toString().toLowerCase().equals(type.toLowerCase())) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase().equals(type.toLowerCase())) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase().equals(boxedType)) {
                return val;
            }
            if (!val.getJavaClass().getSimpleName().toLowerCase().equals(boxedType)) continue;
            return val;
        }
        return null;
    }

    public DatabaseTypeBinding getBinding() {
        return bindings.get((Object)this);
    }

    static {
        bindings = new HashMap<DatabaseTypeEnum, DatabaseTypeBinding>();
        bindings.put(String, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -5155039606411608898L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getString(columnName);
            }

            public Class getType() {
                return String.class;
            }
        });
        bindings.put(BigDecimal, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -648825691097776732L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBigDecimal(columnName);
            }

            public Class getType() {
                return BigDecimal.class;
            }
        });
        bindings.put(Boolean, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 5760469994325386982L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBoolean(columnName);
            }

            public Class getType() {
                return Boolean.class;
            }
        });
        bindings.put(Byte, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -2840004368317980229L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getByte(columnName);
            }

            public Class getType() {
                return Byte.class;
            }
        });
        bindings.put(ByteArray, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 7531500030996242544L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBytes(columnName);
            }

            public Class getType() {
                return byte[].class;
            }
        });
        bindings.put(Double, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -7421693646427315376L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getDouble(columnName);
            }

            public Class getType() {
                return Double.class;
            }
        });
        bindings.put(Float, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -3368945008278992912L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return java.lang.Float.valueOf(resultSet.getFloat(columnName));
            }

            public Class getType() {
                return Float.class;
            }
        });
        bindings.put(Int, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 84694877489363201L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getInt(columnName);
            }

            public Class getType() {
                return Integer.class;
            }
        });
        bindings.put(Long, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -1021242584650775564L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getLong(columnName);
            }

            public Class getType() {
                return Long.class;
            }
        });
        bindings.put(Short, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -2922908857447642497L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getShort(columnName);
            }

            public Class getType() {
                return Short.class;
            }
        });
        bindings.put(SqlDate, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 7869800941910757215L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getDate(columnName);
            }

            public Class getType() {
                return Date.class;
            }
        });
        bindings.put(SqlTime, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -5259494991875064798L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getTime(columnName);
            }

            public Class getType() {
                return Time.class;
            }
        });
        bindings.put(SqlTimestamp, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -8708251362439431175L;

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getTimestamp(columnName);
            }

            public Class getType() {
                return Timestamp.class;
            }
        });
    }
}

