/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimpleNumberCoercerFactory {
    private static SimpleNumberCoercerNull nullCoerce = new SimpleNumberCoercerNull();
    private static SimpleNumberCoercerDouble doubleCoerce = new SimpleNumberCoercerDouble();
    private static SimpleNumberCoercerLong longCoerce = new SimpleNumberCoercerLong();
    private static SimpleNumberCoercerFloat floatCoerce = new SimpleNumberCoercerFloat();
    private static SimpleNumberCoercerInt intCoerce = new SimpleNumberCoercerInt();
    private static SimpleNumberCoercerShort shortCoerce = new SimpleNumberCoercerShort();
    private static SimpleNumberCoercerByte byteCoerce = new SimpleNumberCoercerByte();
    private static SimpleNumberCoercerBigInt bigIntCoerce = new SimpleNumberCoercerBigInt();
    private static SimpleNumberCoercerBigIntNull bigIntCoerceNull = new SimpleNumberCoercerBigIntNull();
    private static SimpleNumberCoercerBigDecLong bigDecCoerceLong = new SimpleNumberCoercerBigDecLong();
    private static SimpleNumberCoercerBigDecDouble bigDecCoerceDouble = new SimpleNumberCoercerBigDecDouble();
    private static SimpleNumberCoercerBigDecNull bigDecCoerceNull = new SimpleNumberCoercerBigDecNull();

    public static SimpleNumberBigDecimalCoercer getCoercerBigDecimal(Class fromType) {
        if (fromType == BigDecimal.class) {
            return bigDecCoerceNull;
        }
        if (JavaClassHelper.isFloatingPointClass(fromType)) {
            return bigDecCoerceDouble;
        }
        return bigDecCoerceLong;
    }

    public static SimpleNumberBigIntegerCoercer getCoercerBigInteger(Class fromType) {
        if (fromType == BigInteger.class) {
            return bigIntCoerceNull;
        }
        return bigIntCoerce;
    }

    public static SimpleNumberCoercer getCoercer(Class fromType, Class resultBoxedType) {
        if (fromType == resultBoxedType) {
            return nullCoerce;
        }
        if (resultBoxedType == Double.class) {
            return doubleCoerce;
        }
        if (resultBoxedType == Long.class) {
            return longCoerce;
        }
        if (resultBoxedType == Float.class) {
            return floatCoerce;
        }
        if (resultBoxedType == Integer.class) {
            return intCoerce;
        }
        if (resultBoxedType == Short.class) {
            return shortCoerce;
        }
        if (resultBoxedType == Byte.class) {
            return byteCoerce;
        }
        if (resultBoxedType == BigInteger.class) {
            return bigIntCoerce;
        }
        if (resultBoxedType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return bigDecCoerceDouble;
            }
            return bigDecCoerceLong;
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + resultBoxedType.getName());
    }

    private static class SimpleNumberCoercerBigDecNull
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        private SimpleNumberCoercerBigDecNull() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return (BigDecimal)numToCoerce;
        }
    }

    private static class SimpleNumberCoercerBigIntNull
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        private SimpleNumberCoercerBigIntNull() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return (BigInteger)numToCoerce;
        }
    }

    private static class SimpleNumberCoercerBigDecDouble
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        private SimpleNumberCoercerBigDecDouble() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }

        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }
    }

    private static class SimpleNumberCoercerBigDecLong
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        private SimpleNumberCoercerBigDecLong() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }

        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }
    }

    private static class SimpleNumberCoercerBigInt
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        private SimpleNumberCoercerBigInt() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }

        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }
    }

    private static class SimpleNumberCoercerByte
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerByte() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.byteValue();
        }
    }

    private static class SimpleNumberCoercerShort
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerShort() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.shortValue();
        }
    }

    private static class SimpleNumberCoercerFloat
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerFloat() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return Float.valueOf(numToCoerce.floatValue());
        }
    }

    private static class SimpleNumberCoercerInt
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerInt() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.intValue();
        }
    }

    private static class SimpleNumberCoercerLong
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerLong() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.longValue();
        }
    }

    private static class SimpleNumberCoercerDouble
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerDouble() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.doubleValue();
        }
    }

    private static class SimpleNumberCoercerNull
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerNull() {
        }

        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }
    }
}

