/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.View;
import com.espertech.esper.view.Viewable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewSupport
implements View {
    protected Viewable parent;
    private final ArrayList<View> children = new ArrayList();
    private static final Log log = LogFactory.getLog(ViewSupport.class);

    protected ViewSupport() {
    }

    @Override
    public final Viewable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Viewable parent) {
        this.parent = parent;
    }

    @Override
    public final View addView(View view) {
        this.children.add(view);
        view.setParent(this);
        return view;
    }

    @Override
    public final boolean removeView(View view) {
        boolean isRemoved = this.children.remove(view);
        view.setParent(null);
        return isRemoved;
    }

    @Override
    public void removeAllViews() {
        this.children.clear();
    }

    @Override
    public final List<View> getViews() {
        return this.children;
    }

    @Override
    public final boolean hasViews() {
        return !this.children.isEmpty();
    }

    public final void updateChildren(EventBean[] newData, EventBean[] oldData) {
        int size = this.children.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.children.get(0).update(newData, oldData);
        } else {
            for (View child : this.children) {
                child.update(newData, oldData);
            }
        }
    }

    protected static void updateChildren(List<View> childViews, EventBean[] newData, EventBean[] oldData) {
        for (View child : childViews) {
            child.update(newData, oldData);
        }
    }

    public static void dumpUpdateParams(String prefix, UniformPair<EventBean[]> result) {
        Object[] newEventArr = result != null ? result.getFirst() : null;
        Object[] oldEventArr = result != null ? result.getSecond() : null;
        ViewSupport.dumpUpdateParams(prefix, newEventArr, oldEventArr);
    }

    public static void dumpUpdateParams(String prefix, Object[] newData, Object[] oldData) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        if (newData == null) {
            writer.println(prefix + " newData=null ");
        } else {
            writer.println(prefix + " newData.size=" + newData.length + "...");
            ViewSupport.printObjectArray(prefix, writer, newData);
        }
        if (oldData == null) {
            writer.println(prefix + " oldData=null ");
        } else {
            writer.println(prefix + " oldData.size=" + oldData.length + "...");
            ViewSupport.printObjectArray(prefix, writer, oldData);
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".dumpUpdateParams Dumping update parameters..." + buffer.toString());
        }
    }

    private static void printObjectArray(String prefix, PrintWriter writer, Object[] objects) {
        int count = 0;
        for (Object object : objects) {
            String objectToString = object == null ? "null" : object.toString();
            writer.println(prefix + " #" + count + " = " + objectToString);
        }
    }

    public static void dumpChildViews(String prefix, Viewable parentViewable) {
        if (log.isDebugEnabled()) {
            for (View child : parentViewable.getViews()) {
                if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                    log.debug(".dumpChildViews " + prefix + ' ' + child.toString());
                }
                ViewSupport.dumpChildViews(prefix + "  ", child);
            }
        }
    }

    public static List<View> findDescendent(Viewable parentView, Viewable descendentView) {
        Stack<View> stack = new Stack<View>();
        for (View view : parentView.getViews()) {
            if (view == descendentView) {
                return stack;
            }
            boolean found = ViewSupport.findDescendentRecusive(view, descendentView, stack);
            if (!found) continue;
            return stack;
        }
        return null;
    }

    private static boolean findDescendentRecusive(View parentView, Viewable descendentView, Stack<View> stack) {
        stack.push(parentView);
        boolean found = false;
        for (View view : parentView.getViews()) {
            if (view == descendentView) {
                return true;
            }
            found = ViewSupport.findDescendentRecusive(view, descendentView, stack);
            if (!found) continue;
            break;
        }
        if (!found) {
            stack.pop();
            return false;
        }
        return true;
    }
}

