/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.View;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZeroDepthStream
implements EventStream {
    private final LinkedList<View> children = new LinkedList();
    private final EventType eventType;
    private EventBean lastInsertedEvent;
    private EventBean[] lastInsertedEvents;
    private static final Log log = LogFactory.getLog(ZeroDepthStream.class);

    public ZeroDepthStream(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void insert(EventBean[] events) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".insert Received event, updating child views, events=" + Arrays.toString(events));
        }
        for (View childView : this.children) {
            childView.update(events, null);
        }
        this.lastInsertedEvents = events;
    }

    @Override
    public final void insert(EventBean event) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".insert Received event, updating child views, event=" + event);
        }
        EventBean[] row = new EventBean[]{event};
        for (View childView : this.children) {
            childView.update(row, null);
        }
        this.lastInsertedEvent = event;
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        if (this.lastInsertedEvents != null) {
            return new ArrayEventIterator(this.lastInsertedEvents);
        }
        return new SingleEventIterator(this.lastInsertedEvent);
    }

    @Override
    public final View addView(View view) {
        this.children.add(view);
        view.setParent(this);
        return view;
    }

    @Override
    public final List<View> getViews() {
        return this.children;
    }

    @Override
    public final boolean removeView(View view) {
        boolean isRemoved = this.children.remove(view);
        view.setParent(null);
        return isRemoved;
    }

    @Override
    public final boolean hasViews() {
        return !this.children.isEmpty();
    }

    @Override
    public void removeAllViews() {
        this.children.clear();
    }
}

